/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.upnp.service.contentdirectory.definition;

import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.xpath.XPathExpressionException;
import org.serviio.library.search.SearchIndexer;
import org.serviio.upnp.service.contentdirectory.classes.ObjectClassType;
import org.serviio.upnp.service.contentdirectory.definition.ActionNode;
import org.serviio.upnp.service.contentdirectory.definition.ContainerNode;
import org.serviio.upnp.service.contentdirectory.definition.ContentDirectoryDefinitionException;
import org.serviio.upnp.service.contentdirectory.definition.Definition;
import org.serviio.upnp.service.contentdirectory.definition.DefinitionNode;
import org.serviio.upnp.service.contentdirectory.definition.StaticContainerNode;
import org.serviio.util.ObjectValidator;
import org.serviio.util.XPathUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ContentDirectoryDefinitionParser {
    private static final Logger log = LoggerFactory.getLogger(ContentDirectoryDefinitionParser.class);
    private static final String TAG_ACTION = "action";
    private static final String TAG_CONTAINER = "container";

    public static Definition parseDefinition(InputStream definitionStream) throws ContentDirectoryDefinitionException {
        if (definitionStream == null) {
            throw new ContentDirectoryDefinitionException("ContentDirectory definition is not present.");
        }
        try {
            Node definitionRoot = XPathUtil.getRootNode(definitionStream);
            Node rootContainerNode = XPathUtil.getNode(definitionRoot, TAG_CONTAINER);
            if (rootContainerNode == null) {
                throw new ContentDirectoryDefinitionException("ContentDirectory definition doesn't contain a root node.");
            }
            log.info("Parsing ContentDirectory definition");
            ContainerNode root = ContentDirectoryDefinitionParser.createContainerNode(rootContainerNode, null);
            ContentDirectoryDefinitionParser.processNodeChildren(rootContainerNode, root);
            Definition definition = new Definition(root);
            return definition;
        }
        catch (XPathExpressionException e) {
            throw new ContentDirectoryDefinitionException("Cannot parse definition XML. It is corrupted.");
        }
    }

    private static void processNodeChildren(Node parentNode, ContainerNode parentDefinitionNode) throws ContentDirectoryDefinitionException, XPathExpressionException {
        NodeList childNodes = XPathUtil.getNodeSet(parentNode, "./*");
        for (int i = 0; i < childNodes.getLength(); ++i) {
            ContainerNode childDefinitionNode;
            Node childNode = childNodes.item(i);
            if (childNode.getLocalName().equals(TAG_CONTAINER)) {
                childDefinitionNode = ContentDirectoryDefinitionParser.createContainerNode(childNode, parentDefinitionNode);
            } else if (childNode.getLocalName().equals(TAG_ACTION)) {
                childDefinitionNode = ContentDirectoryDefinitionParser.createActionNode(childNode, parentDefinitionNode);
            } else {
                throw new ContentDirectoryDefinitionException(String.format("Unsupported tag encountered: %s", childNode.getLocalName()));
            }
            parentDefinitionNode.getChildNodes().add(childDefinitionNode);
            if (!(childDefinitionNode instanceof ContainerNode)) continue;
            ContentDirectoryDefinitionParser.processNodeChildren(childNode, childDefinitionNode);
        }
    }

    private static ContainerNode createContainerNode(Node node, DefinitionNode parent) throws ContentDirectoryDefinitionException, XPathExpressionException {
        String nodeId = XPathUtil.getNodeValue(node, "@id");
        String nodeTitleKey = XPathUtil.getNodeValue(node, "@title_key");
        String nodeContainerClass = XPathUtil.getNodeValue(node, "@containerClass");
        String nodeBrowsable = XPathUtil.getNodeValue(node, "@browsable");
        String nodeEditable = XPathUtil.getNodeValue(node, "@editable");
        String nodeCacheRegion = XPathUtil.getNodeValue(node, "@cacheRegion");
        log.debug(String.format("Found Container node with attributes: id=%s, titleKey=%s, class=%s, cacheRegion=%s, browsable = %s, editable = %s", nodeId, nodeTitleKey, nodeContainerClass, nodeCacheRegion, nodeBrowsable, nodeEditable));
        try {
            StaticContainerNode container = new StaticContainerNode(nodeId, nodeTitleKey, ObjectClassType.valueOf(nodeContainerClass), parent, nodeCacheRegion);
            if (ObjectValidator.isNotEmpty(nodeBrowsable)) {
                container.setBrowsable(Boolean.parseBoolean(nodeBrowsable));
            }
            if (ObjectValidator.isNotEmpty(nodeEditable)) {
                container.setEditable(Boolean.parseBoolean(nodeEditable));
            }
            container.validate();
            return container;
        }
        catch (IllegalArgumentException e) {
            throw new ContentDirectoryDefinitionException(String.format("Object class %s doesn't exist", nodeContainerClass), e);
        }
    }

    private static ActionNode createActionNode(Node node, DefinitionNode parent) throws ContentDirectoryDefinitionException, XPathExpressionException {
        String nodeCommandClass = XPathUtil.getNodeValue(node, "@command");
        String nodeContainerClass = XPathUtil.getNodeValue(node, "@containerClass");
        String nodeItemClass = XPathUtil.getNodeValue(node, "@itemClass");
        String nodeIdPrefix = XPathUtil.getNodeValue(node, "@idPrefix");
        boolean recursive = Boolean.valueOf(XPathUtil.getNodeValue(node, "@recursive"));
        String nodeCacheRegion = XPathUtil.getNodeValue(node, "@cacheRegion");
        String nodeSearchCategories = XPathUtil.getNodeValue(node, "@searchCategory");
        log.debug(String.format("Found Action node with attributes: command=%s, containerClass=%s, itemClass=%s, idPrefix=%s, recursive=%s, cacheRegion=%s", nodeCommandClass, nodeContainerClass, nodeItemClass, nodeIdPrefix, recursive, nodeCacheRegion));
        try {
            ObjectClassType containerClassType = ObjectValidator.isNotEmpty(nodeContainerClass) ? ObjectClassType.valueOf(nodeContainerClass) : null;
            ArrayList<SearchIndexer.SearchCategory> searchCategories = new ArrayList<SearchIndexer.SearchCategory>();
            if (ObjectValidator.isNotEmpty(nodeSearchCategories)) {
                for (String searchCategory : nodeSearchCategories.split("\\s")) {
                    searchCategories.add(SearchIndexer.SearchCategory.valueOf(searchCategory));
                }
            }
            ObjectClassType itemClassType = ObjectValidator.isNotEmpty(nodeItemClass) ? ObjectClassType.valueOf(nodeItemClass) : null;
            ActionNode action = new ActionNode(nodeCommandClass, nodeIdPrefix, containerClassType, itemClassType, parent, nodeCacheRegion, recursive, searchCategories);
            action.validate();
            return action;
        }
        catch (IllegalArgumentException e) {
            throw new ContentDirectoryDefinitionException(String.format("Object class doesn't exist: %s", e.getMessage()), e);
        }
    }
}

