/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.upnp.service.contentdirectory.definition;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import org.serviio.library.entities.AccessGroup;
import org.serviio.profile.Profile;
import org.serviio.upnp.service.contentdirectory.BrowseItemsHolder;
import org.serviio.upnp.service.contentdirectory.ObjectType;
import org.serviio.upnp.service.contentdirectory.SearchCriteria;
import org.serviio.upnp.service.contentdirectory.classes.DirectoryObject;
import org.serviio.upnp.service.contentdirectory.classes.ObjectClassType;
import org.serviio.upnp.service.contentdirectory.command.Command;
import org.serviio.upnp.service.contentdirectory.command.CommandExecutionException;
import org.serviio.upnp.service.contentdirectory.definition.ActionNode;
import org.serviio.upnp.service.contentdirectory.definition.ContentDirectoryDefinitionException;
import org.serviio.upnp.service.contentdirectory.definition.Definition;
import org.serviio.upnp.service.contentdirectory.definition.DefinitionNode;
import org.serviio.upnp.service.contentdirectory.definition.StaticContainerNode;
import org.serviio.upnp.service.contentdirectory.definition.StaticDefinitionNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ContainerNode
extends DefinitionNode {
    private static final Logger log = LoggerFactory.getLogger(ContainerNode.class);
    protected List<DefinitionNode> childNodes = new ArrayList<DefinitionNode>();

    public ContainerNode(ObjectClassType objectClass, DefinitionNode parent, String cacheRegion) {
        super(objectClass, parent, cacheRegion);
    }

    public BrowseItemsHolder<DirectoryObject> retrieveContainerItems(String containerId, ObjectType objectType, SearchCriteria searchCriteria, int startIndex, int count, Profile rendererProfile, AccessGroup userProfile, boolean disablePresentationSettings) {
        List<DirectoryObject> items;
        BrowseItemsHolder<DirectoryObject> resultHolder = new BrowseItemsHolder<DirectoryObject>();
        new ArrayList();
        int[] totalFound = new int[1];
        int[] returned = new int[1];
        if (count == 0) {
            count = Integer.MAX_VALUE;
        }
        resultHolder.setItems((items = this.findContainerItems(containerId, objectType, searchCriteria, startIndex, count, returned, totalFound, rendererProfile, userProfile, disablePresentationSettings)).size() < count ? items : items.subList(0, count));
        resultHolder.setTotalMatched(totalFound[0]);
        return resultHolder;
    }

    public int retrieveContainerItemsCount(String containerId, ObjectType objectType, SearchCriteria searchCriteria, AccessGroup userProfile, boolean disablePresentationSettings) {
        int totalFound = 0;
        Definition def = Definition.instance();
        for (DefinitionNode childNode : this.childNodes) {
            if (childNode instanceof StaticDefinitionNode) {
                String childNodeId = ((StaticDefinitionNode)((Object)childNode)).getId();
                if (def.isDisabledContainer(childNodeId, disablePresentationSettings) || !objectType.supportsContainers()) continue;
                if (def.isOnlyShowContentsOfContainer(childNodeId, disablePresentationSettings)) {
                    if (!(childNode instanceof StaticContainerNode)) continue;
                    StaticContainerNode disabledContainerNode = (StaticContainerNode)childNode;
                    totalFound += disabledContainerNode.retrieveContainerItemsCount(disabledContainerNode.getId(), objectType, searchCriteria, userProfile, disablePresentationSettings);
                    continue;
                }
                ++totalFound;
                continue;
            }
            int count = this.executeCountAction(containerId, objectType, searchCriteria, ((ActionNode)childNode).getCommandClass(), userProfile, ((ActionNode)childNode).getIdPrefix(), disablePresentationSettings);
            totalFound += count;
        }
        return totalFound;
    }

    @Override
    public void validate() throws ContentDirectoryDefinitionException {
        super.validate();
        if (this.containerClass == null) {
            throw new ContentDirectoryDefinitionException("Container class not provided in definition.");
        }
    }

    protected List<DirectoryObject> findContainerItems(String containerId, ObjectType objectType, SearchCriteria searchCriteria, Integer startIndex, Integer requestedCount, int[] returned, int[] totalFound, Profile rendererProfile, AccessGroup userProfile, boolean disablePresentationSettings) {
        ArrayList<DirectoryObject> items = new ArrayList<DirectoryObject>();
        Definition def = Definition.instance();
        for (DefinitionNode node : this.childNodes) {
            if (node instanceof StaticContainerNode) {
                StaticContainerNode staticContainer = (StaticContainerNode)node;
                if (!staticContainer.isBrowsable() || def.isDisabledContainer(staticContainer.getId(), disablePresentationSettings) || !objectType.supportsContainers()) continue;
                if (returned[0] < requestedCount) {
                    if (def.isEnabledContainer(staticContainer.getId(), disablePresentationSettings)) {
                        if (startIndex <= totalFound[0]) {
                            items.add(staticContainer.retrieveDirectoryObject(staticContainer.getId(), objectType, rendererProfile, userProfile, disablePresentationSettings));
                            returned[0] = returned[0] + 1;
                        }
                        totalFound[0] = totalFound[0] + 1;
                        continue;
                    }
                    items.addAll(staticContainer.findContainerItems(staticContainer.getId(), objectType, searchCriteria, startIndex, requestedCount, returned, totalFound, rendererProfile, userProfile, disablePresentationSettings));
                    continue;
                }
                if (def.isEnabledContainer(staticContainer.getId(), disablePresentationSettings)) {
                    totalFound[0] = totalFound[0] + 1;
                    continue;
                }
                totalFound[0] = totalFound[0] + staticContainer.retrieveContainerItemsCount(staticContainer.getId(), objectType, searchCriteria, userProfile, disablePresentationSettings);
                continue;
            }
            int from = Math.max(0, startIndex - totalFound[0] + returned[0]);
            BrowseItemsHolder holder = this.executeListAction(containerId, objectType, searchCriteria, ((ActionNode)node).getCommandClass(), node.getContainerClass(), node.getItemClass(), rendererProfile, userProfile, ((ActionNode)node).getIdPrefix(), from, requestedCount - returned[0], disablePresentationSettings);
            if (holder == null) continue;
            totalFound[0] = totalFound[0] + holder.getTotalMatched();
            returned[0] = returned[0] + holder.getReturnedSize();
            items.addAll(holder.getItems());
        }
        return items;
    }

    protected <T extends DirectoryObject> Command<T> instantiateCommand(String containerId, ObjectType objectType, SearchCriteria searchCriteria, String commandClass, ObjectClassType containerClassType, ObjectClassType itemClassType, Profile rendererProfile, AccessGroup userProfile, String idPrefix, int startIndex, int count, boolean disablePresentationSettings) {
        try {
            Class<?> clazz = Class.forName(commandClass);
            if (Command.class.isAssignableFrom(clazz)) {
                Constructor<?> c = clazz.getConstructor(String.class, ObjectType.class, SearchCriteria.class, ObjectClassType.class, ObjectClassType.class, Profile.class, AccessGroup.class, String.class, Integer.TYPE, Integer.TYPE, Boolean.TYPE);
                Command command = (Command)c.newInstance(new Object[]{containerId, objectType, searchCriteria, containerClassType, itemClassType, rendererProfile, userProfile, idPrefix, startIndex, count, disablePresentationSettings});
                return command;
            }
            log.error(String.format("Cannot instantiate Command %s because it doesn't implement Command interface", commandClass));
        }
        catch (Exception e) {
            log.error(String.format("Cannot instantiate Command %s: %s", commandClass, e.getMessage()));
        }
        return null;
    }

    protected <T extends DirectoryObject> int executeCountAction(String containerId, ObjectType objectType, SearchCriteria searchCriteria, String commandClass, AccessGroup userProfile, String idPrefix, boolean disablePresentationSettings) {
        Command<T> command = this.instantiateCommand(containerId, objectType, searchCriteria, commandClass, null, null, null, userProfile, idPrefix, 0, 0, disablePresentationSettings);
        try {
            return command.retrieveItemCount();
        }
        catch (CommandExecutionException e) {
            log.error(String.format("Cannot retrieve results of action count command: %s", e.getMessage()), (Throwable)e);
            return 0;
        }
    }

    protected <T extends DirectoryObject> BrowseItemsHolder<T> executeListAction(String containerId, ObjectType objectType, SearchCriteria searchCriteria, String commandClass, ObjectClassType containerClassType, ObjectClassType itemClassType, Profile rendererProfile, AccessGroup userProfile, String idPrefix, int startIndex, int count, boolean disablePresentationSettings) {
        ObjectClassType filteredContainerClassType = containerClassType;
        if (rendererProfile.getContentDirectoryDefinitionFilter() != null) {
            filteredContainerClassType = rendererProfile.getContentDirectoryDefinitionFilter().filterContainerClassType(containerClassType, containerId);
        }
        Command<T> command = this.instantiateCommand(containerId, objectType, searchCriteria, commandClass, filteredContainerClassType, itemClassType, rendererProfile, userProfile, idPrefix, startIndex, count, disablePresentationSettings);
        try {
            return command.retrieveItemList();
        }
        catch (CommandExecutionException e) {
            log.error(String.format("Cannot retrieve results of action command: %s", e.getMessage()), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public List<DefinitionNode> getChildNodes() {
        return this.childNodes;
    }
}

