/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.upnp.service.contentdirectory.definition;

import java.util.List;
import org.serviio.library.entities.AccessGroup;
import org.serviio.library.search.SearchIndexer;
import org.serviio.profile.Profile;
import org.serviio.upnp.service.contentdirectory.BrowseItemsHolder;
import org.serviio.upnp.service.contentdirectory.ObjectType;
import org.serviio.upnp.service.contentdirectory.SearchCriteria;
import org.serviio.upnp.service.contentdirectory.classes.DirectoryObject;
import org.serviio.upnp.service.contentdirectory.classes.ObjectClassType;
import org.serviio.upnp.service.contentdirectory.command.Command;
import org.serviio.upnp.service.contentdirectory.command.CommandExecutionException;
import org.serviio.upnp.service.contentdirectory.definition.ContainerNode;
import org.serviio.upnp.service.contentdirectory.definition.ContentDirectoryDefinitionException;
import org.serviio.upnp.service.contentdirectory.definition.DefinitionNode;
import org.serviio.util.ObjectValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionNode
extends ContainerNode {
    private static final Logger log = LoggerFactory.getLogger(ActionNode.class);
    private String commandClass;
    private String idPrefix;
    private boolean recursive;
    private List<SearchIndexer.SearchCategory> searchCategories;

    public ActionNode(String commandClassName, String idPrefix, ObjectClassType containerClass, ObjectClassType itemClass, DefinitionNode parent, String cacheRegion, boolean recursive, List<SearchIndexer.SearchCategory> searchCategories) {
        super(containerClass, parent, cacheRegion);
        this.itemClass = itemClass;
        this.commandClass = commandClassName;
        this.idPrefix = idPrefix;
        this.recursive = recursive;
        this.searchCategories = searchCategories;
    }

    @Override
    public DirectoryObject retrieveDirectoryObject(String objectId, ObjectType objectType, Profile rendererProfile, AccessGroup userProfile, boolean disablePresentationSettings) {
        return this.executeRetrieveItemAction(objectId, objectType, rendererProfile, userProfile, disablePresentationSettings);
    }

    @Override
    public void validate() throws ContentDirectoryDefinitionException {
        if (this.containerClass == null && this.itemClass == null) {
            throw new ContentDirectoryDefinitionException("Container class or Item class must be provided in definition.");
        }
        if (ObjectValidator.isEmpty(this.commandClass)) {
            throw new ContentDirectoryDefinitionException("Action Command not provided.");
        }
        if (ObjectValidator.isEmpty(this.idPrefix)) {
            throw new ContentDirectoryDefinitionException("Action idPrefix not provided.");
        }
        if (this.recursive && !this.childNodes.isEmpty()) {
            throw new ContentDirectoryDefinitionException("Recursive Actions cannot include any children nodes.");
        }
    }

    @Override
    public BrowseItemsHolder<DirectoryObject> retrieveContainerItems(String containerId, ObjectType objectType, SearchCriteria searchCriteria, int startIndex, int count, Profile rendererProfile, AccessGroup userProfile, boolean disablePresentationSettings) {
        if (count == 0) {
            count = Integer.MAX_VALUE;
        }
        if (this.recursive) {
            BrowseItemsHolder<DirectoryObject> holder = this.executeListAction(containerId, objectType, searchCriteria, this.getCommandClass(), this.getContainerClass(), this.getItemClass(), rendererProfile, userProfile, this.getIdPrefix(), startIndex, count, disablePresentationSettings);
            return holder;
        }
        return super.retrieveContainerItems(containerId, objectType, searchCriteria, startIndex, count, rendererProfile, userProfile, disablePresentationSettings);
    }

    @Override
    public int retrieveContainerItemsCount(String containerId, ObjectType objectType, SearchCriteria searchCriteria, AccessGroup userProfile, boolean disablePresentationSettings) {
        if (this.recursive) {
            int count = this.executeCountAction(containerId, objectType, searchCriteria, this.getCommandClass(), userProfile, "", disablePresentationSettings);
            return count;
        }
        return super.retrieveContainerItemsCount(containerId, objectType, searchCriteria, userProfile, disablePresentationSettings);
    }

    protected <T extends DirectoryObject> T executeRetrieveItemAction(String containerId, ObjectType objectType, Profile rendererProfile, AccessGroup userProfile, boolean disablePresentationSettings) {
        ObjectClassType containerClassType = this.containerClass;
        if (rendererProfile.getContentDirectoryDefinitionFilter() != null) {
            containerClassType = rendererProfile.getContentDirectoryDefinitionFilter().filterContainerClassType(containerClassType, containerId);
        }
        Command command = this.instantiateCommand(containerId, objectType, null, this.commandClass, containerClassType, this.itemClass, rendererProfile, userProfile, this.idPrefix, 0, 1, disablePresentationSettings);
        try {
            return command.retrieveItem();
        }
        catch (CommandExecutionException e) {
            log.error(String.format("Cannot retrieve results of action command: %s", e.getMessage()), (Throwable)e);
            return null;
        }
    }

    public String getCommandClass() {
        return this.commandClass;
    }

    public String getIdPrefix() {
        return this.idPrefix;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public List<SearchIndexer.SearchCategory> getSearchCategories() {
        return this.searchCategories;
    }
}

