/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.upnp.service.contentdirectory.command.video;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.serviio.library.entities.AccessGroup;
import org.serviio.library.entities.Genre;
import org.serviio.library.local.service.GenreService;
import org.serviio.library.metadata.MediaFileType;
import org.serviio.profile.Profile;
import org.serviio.upnp.service.contentdirectory.ObjectType;
import org.serviio.upnp.service.contentdirectory.SearchCriteria;
import org.serviio.upnp.service.contentdirectory.classes.ObjectClassType;
import org.serviio.upnp.service.contentdirectory.command.AbstractEntityContainerCommand;

public class ListVideoGenresByNameCommand
extends AbstractEntityContainerCommand<Genre> {
    public ListVideoGenresByNameCommand(String objectId, ObjectType objectType, SearchCriteria searchCriteria, ObjectClassType containerClassType, ObjectClassType itemClassType, Profile rendererProfile, AccessGroup accessGroup, String idPrefix, int startIndex, int count, boolean disablePresentationSettings) {
        super(objectId, objectType, searchCriteria, containerClassType, itemClassType, rendererProfile, accessGroup, MediaFileType.VIDEO, idPrefix, startIndex, count, disablePresentationSettings);
    }

    @Override
    protected Set<ObjectClassType> getSupportedClasses() {
        return new HashSet<ObjectClassType>(Arrays.asList(ObjectClassType.CONTAINER, ObjectClassType.GENRE, ObjectClassType.STORAGE_FOLDER));
    }

    @Override
    protected List<Genre> retrieveEntityList() {
        List<Genre> genres = GenreService.getListOfGenres(MediaFileType.VIDEO, this.startIndex, this.count);
        return genres;
    }

    @Override
    protected Genre retrieveSingleEntity(Long entityId) {
        Genre genre = GenreService.getGenre(entityId);
        return genre;
    }

    @Override
    public int retrieveItemCount() {
        return GenreService.getNumberOfGenres(MediaFileType.VIDEO);
    }

    @Override
    protected String getContainerTitle(Genre genre) {
        return genre.getName();
    }
}

