/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.upnp.service.contentdirectory.command.video;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.serviio.library.entities.AccessGroup;
import org.serviio.library.entities.Series;
import org.serviio.library.local.service.VideoService;
import org.serviio.library.metadata.MediaFileType;
import org.serviio.profile.Profile;
import org.serviio.upnp.service.contentdirectory.ObjectType;
import org.serviio.upnp.service.contentdirectory.SearchCriteria;
import org.serviio.upnp.service.contentdirectory.classes.ObjectClassType;
import org.serviio.upnp.service.contentdirectory.command.AbstractEntityContainerCommand;

public class ListSeriesByNameCommand
extends AbstractEntityContainerCommand<Series> {
    public ListSeriesByNameCommand(String objectId, ObjectType objectType, SearchCriteria searchCriteria, ObjectClassType containerClassType, ObjectClassType itemClassType, Profile rendererProfile, AccessGroup accessGroup, String idPrefix, int startIndex, int count, boolean disablePresentationSettings) {
        super(objectId, objectType, searchCriteria, containerClassType, itemClassType, rendererProfile, accessGroup, MediaFileType.VIDEO, idPrefix, startIndex, count, disablePresentationSettings);
    }

    @Override
    protected Set<ObjectClassType> getSupportedClasses() {
        return new HashSet<ObjectClassType>(Arrays.asList(ObjectClassType.CONTAINER, ObjectClassType.STORAGE_FOLDER));
    }

    @Override
    protected List<Series> retrieveEntityList() {
        List<Series> series = VideoService.getListOfSeries(this.startIndex, this.count);
        return series;
    }

    @Override
    protected Series retrieveSingleEntity(Long entityId) {
        Series series = VideoService.getSeries(entityId);
        return series;
    }

    @Override
    public int retrieveItemCount() {
        return VideoService.getNumberOfSeries();
    }

    @Override
    protected String getContainerTitle(Series series) {
        return series.getTitle();
    }
}

