/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.upnp.service.contentdirectory.command.video;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.serviio.library.entities.AccessGroup;
import org.serviio.library.local.service.VideoService;
import org.serviio.library.metadata.MediaFileType;
import org.serviio.profile.Profile;
import org.serviio.upnp.service.contentdirectory.ObjectType;
import org.serviio.upnp.service.contentdirectory.SearchCriteria;
import org.serviio.upnp.service.contentdirectory.classes.ClassProperties;
import org.serviio.upnp.service.contentdirectory.classes.Container;
import org.serviio.upnp.service.contentdirectory.classes.DirectoryObjectBuilder;
import org.serviio.upnp.service.contentdirectory.classes.ObjectClassType;
import org.serviio.upnp.service.contentdirectory.command.AbstractCommand;
import org.serviio.upnp.service.contentdirectory.command.CommandExecutionException;
import org.serviio.upnp.service.contentdirectory.command.ObjectValuesBuilder;
import org.serviio.upnp.service.contentdirectory.definition.Definition;
import org.serviio.upnp.service.contentdirectory.definition.i18n.BrowsingCategoriesMessages;

public class ListSeasonsForSeriesCommand
extends AbstractCommand<Container> {
    public ListSeasonsForSeriesCommand(String contextIdentifier, ObjectType objectType, SearchCriteria searchCriteria, ObjectClassType containerClassType, ObjectClassType itemClassType, Profile rendererProfile, AccessGroup accessGroup, String idPrefix, int startIndex, int count, boolean disablePresentationSettings) {
        super(contextIdentifier, objectType, searchCriteria, containerClassType, itemClassType, rendererProfile, accessGroup, MediaFileType.VIDEO, idPrefix, startIndex, count, disablePresentationSettings);
    }

    @Override
    protected Set<ObjectClassType> getSupportedClasses() {
        return new HashSet<ObjectClassType>(Arrays.asList(ObjectClassType.CONTAINER, ObjectClassType.STORAGE_FOLDER));
    }

    @Override
    protected Set<ObjectType> getSupportedObjectTypes() {
        return ObjectType.getContainerTypes();
    }

    @Override
    protected List<Container> retrieveList() {
        ArrayList<Container> items = new ArrayList<Container>();
        List<Integer> seasons = VideoService.getListOfSeasonsForSeries(new Long(this.getInternalObjectId()), this.accessGroup, this.startIndex, this.count);
        Integer lastViewedSeason = this.getLastViewedSeason(new Long(this.getInternalObjectId()));
        for (Integer seasonNumber : seasons) {
            String runtimeId = this.generateRuntimeObjectId(seasonNumber);
            String containerTitle = this.getContainerTitle(seasonNumber, lastViewedSeason);
            Map<ClassProperties, Object> values = ObjectValuesBuilder.instantiateValuesForContainer(containerTitle, runtimeId, this.getDisplayedContainerId(this.objectId), this.objectType, this.searchCriteria, this.accessGroup, null, this.disablePresentationSettings);
            items.add((Container)DirectoryObjectBuilder.createInstance(this.containerClassType, values, null, null, this.disablePresentationSettings));
        }
        return items;
    }

    @Override
    protected Container retrieveSingleItem() {
        Long seriesId = Long.parseLong(this.getInternalObjectId(Definition.instance().getParentNodeId(this.objectId, this.disablePresentationSettings)));
        Integer seasonNumber = new Integer(this.getInternalObjectId());
        Integer lastViewedSeason = this.getLastViewedSeason(seriesId);
        String containerTitle = this.getContainerTitle(seasonNumber, lastViewedSeason);
        Map<ClassProperties, Object> values = ObjectValuesBuilder.instantiateValuesForContainer(containerTitle, this.objectId, Definition.instance().getParentNodeId(this.objectId, this.disablePresentationSettings), this.objectType, this.searchCriteria, this.accessGroup, null, this.disablePresentationSettings);
        return (Container)DirectoryObjectBuilder.createInstance(this.containerClassType, values, null, null, this.disablePresentationSettings);
    }

    private String getContainerTitle(Integer seasonNumber, Integer lastViewedSeason) {
        String containerTitle = String.format("%s %02d%s", BrowsingCategoriesMessages.getMessage("season", new Object[0]), seasonNumber, lastViewedSeason != null && lastViewedSeason.equals(seasonNumber) ? " **" : "");
        return containerTitle;
    }

    @Override
    public int retrieveItemCount() throws CommandExecutionException {
        return VideoService.getNumberOfSeasonsForSeries(new Long(this.getInternalObjectId()), this.accessGroup);
    }

    protected Integer getLastViewedSeason(Long seriesId) {
        Map<Long, Integer> lastViewed = VideoService.getLastViewedEpisode(seriesId);
        if (lastViewed != null) {
            return lastViewed.entrySet().iterator().next().getValue();
        }
        return null;
    }
}

