/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.upnp.service.contentdirectory.command.video;

import java.util.List;
import java.util.Map;
import org.serviio.library.entities.AccessGroup;
import org.serviio.library.entities.Video;
import org.serviio.library.local.service.VideoService;
import org.serviio.profile.Profile;
import org.serviio.upnp.service.contentdirectory.ObjectType;
import org.serviio.upnp.service.contentdirectory.SearchCriteria;
import org.serviio.upnp.service.contentdirectory.classes.ObjectClassType;
import org.serviio.upnp.service.contentdirectory.command.video.AbstractVideosRetrievalCommand;
import org.serviio.upnp.service.contentdirectory.definition.Definition;

public class ListEpisodesForSeriesSeasonCommand
extends AbstractVideosRetrievalCommand {
    public ListEpisodesForSeriesSeasonCommand(String contextIdentifier, ObjectType objectType, SearchCriteria searchCriteria, ObjectClassType containerClassType, ObjectClassType itemClassType, Profile rendererProfile, AccessGroup accessGroup, String idPrefix, int startIndex, int count, boolean disablePresentationSettings) {
        super(contextIdentifier, objectType, searchCriteria, containerClassType, itemClassType, rendererProfile, accessGroup, idPrefix, startIndex, count, disablePresentationSettings);
    }

    @Override
    protected List<Video> retrieveEntityList() {
        List<Video> videos = VideoService.getListOfEpisodesForSeriesSeason(this.getSeriesId(), this.getSeason(), this.accessGroup, this.startIndex, this.count);
        return videos;
    }

    @Override
    public int retrieveItemCount() {
        return VideoService.getNumberOfEpisodesForSeriesSeason(this.getSeriesId(), this.getSeason(), this.accessGroup);
    }

    @Override
    protected String getItemTitle(Video video, boolean markedItem) {
        return String.format("%02d. %s%s", video.getEpisodeNumber(), markedItem ? "** " : "", video.getTitle());
    }

    @Override
    protected Long findMarkedItemId(boolean forSingleItem) {
        Long seriesId = null;
        seriesId = forSingleItem ? Long.valueOf(Long.parseLong(this.getInternalObjectId(Definition.instance().getParentNodeId(Definition.instance().getParentNodeId(this.objectId, this.disablePresentationSettings), this.disablePresentationSettings)))) : this.getSeriesId();
        return this.getLastViewedEpisode(seriesId);
    }

    private Long getSeriesId() {
        Long seasonId = Long.parseLong(this.getInternalObjectId(Definition.instance().getParentNodeId(this.objectId, this.disablePresentationSettings)));
        return seasonId;
    }

    private Integer getSeason() {
        Integer season = Integer.parseInt(this.getInternalObjectId());
        return season;
    }

    protected Long getLastViewedEpisode(Long seriesId) {
        Map<Long, Integer> lastViewed = VideoService.getLastViewedEpisode(seriesId);
        if (lastViewed != null) {
            return lastViewed.entrySet().iterator().next().getKey();
        }
        return null;
    }
}

