/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.upnp.service.contentdirectory.command.video;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.serviio.library.entities.AccessGroup;
import org.serviio.library.entities.Series;
import org.serviio.library.entities.Video;
import org.serviio.library.local.service.VideoService;
import org.serviio.library.metadata.MediaFileType;
import org.serviio.profile.Profile;
import org.serviio.upnp.service.contentdirectory.ObjectType;
import org.serviio.upnp.service.contentdirectory.SearchCriteria;
import org.serviio.upnp.service.contentdirectory.classes.ObjectClassType;
import org.serviio.upnp.service.contentdirectory.command.AbstractEntityItemCommand;

public abstract class AbstractVideosRetrievalCommand
extends AbstractEntityItemCommand<Video> {
    public AbstractVideosRetrievalCommand(String contextIdentifier, ObjectType objectType, SearchCriteria searchCriteria, ObjectClassType containerClassType, ObjectClassType itemClassType, Profile rendererProfile, AccessGroup accessGroup, String idPrefix, int startIndex, int count, boolean disablePresentationSettings) {
        super(contextIdentifier, objectType, searchCriteria, containerClassType, itemClassType, rendererProfile, accessGroup, MediaFileType.VIDEO, idPrefix, startIndex, count, disablePresentationSettings);
    }

    @Override
    protected final Set<ObjectClassType> getSupportedClasses() {
        return new HashSet<ObjectClassType>(Arrays.asList(ObjectClassType.VIDEO_ITEM, ObjectClassType.MOVIE));
    }

    @Override
    protected Video retrieveSingleEntity(Long entityId) {
        Video video = VideoService.getVideo(entityId);
        return video;
    }

    @Override
    protected String getItemTitle(Video video, boolean markedItem) {
        if (video.getSeriesId() != null) {
            Series series = VideoService.getSeries(video.getSeriesId());
            return this.getEpisodeTitle(video, series);
        }
        return this.getMovieTitle(video);
    }

    protected String getEpisodeTitle(Video video, Series series) {
        return String.format("%s (%s/%02d): %s", series.getTitle(), video.getSeasonNumber(), video.getEpisodeNumber(), video.getTitle());
    }

    protected String getMovieTitle(Video video) {
        return video.getTitle();
    }
}

