/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.upnp.service.contentdirectory.command.person;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.serviio.library.entities.AccessGroup;
import org.serviio.library.entities.Person;
import org.serviio.library.local.service.PersonService;
import org.serviio.library.metadata.MediaFileType;
import org.serviio.profile.Profile;
import org.serviio.upnp.service.contentdirectory.ObjectType;
import org.serviio.upnp.service.contentdirectory.SearchCriteria;
import org.serviio.upnp.service.contentdirectory.classes.ObjectClassType;
import org.serviio.upnp.service.contentdirectory.command.AbstractEntityContainerCommand;
import org.serviio.util.StringUtils;

public abstract class AbstractPersonsRetrievalCommand
extends AbstractEntityContainerCommand<Person> {
    public AbstractPersonsRetrievalCommand(String contextIdentifier, ObjectType objectType, SearchCriteria searchCriteria, ObjectClassType containerClassType, ObjectClassType itemClassType, Profile rendererProfile, AccessGroup accessGroup, MediaFileType fileType, String idPrefix, int startIndex, int count, boolean disablePresentationSettings) {
        super(contextIdentifier, objectType, searchCriteria, containerClassType, itemClassType, rendererProfile, accessGroup, fileType, idPrefix, startIndex, count, disablePresentationSettings);
    }

    @Override
    protected Set<ObjectClassType> getSupportedClasses() {
        return new HashSet<ObjectClassType>(Arrays.asList(ObjectClassType.CONTAINER, ObjectClassType.PERSON, ObjectClassType.MUSIC_ARTIST, ObjectClassType.STORAGE_FOLDER));
    }

    @Override
    protected Person retrieveSingleEntity(Long entityId) {
        Person person = PersonService.getPerson(entityId);
        return person;
    }

    @Override
    protected String getContainerTitle(Person person) {
        return person.getName();
    }

    protected String getInitialFromId(String objectId) {
        return StringUtils.getCharacterForCode(Integer.parseInt(objectId));
    }
}

