/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.upnp.service.contentdirectory.command.image;

import java.util.List;
import org.serviio.library.entities.AccessGroup;
import org.serviio.library.entities.Image;
import org.serviio.library.local.service.ImageService;
import org.serviio.profile.Profile;
import org.serviio.upnp.service.contentdirectory.ObjectType;
import org.serviio.upnp.service.contentdirectory.SearchCriteria;
import org.serviio.upnp.service.contentdirectory.classes.ObjectClassType;
import org.serviio.upnp.service.contentdirectory.command.image.AbstractImagesRetrievalCommand;
import org.serviio.upnp.service.contentdirectory.definition.Definition;

public class ListImagesForCreationMonthAndYearCommand
extends AbstractImagesRetrievalCommand {
    public ListImagesForCreationMonthAndYearCommand(String contextIdentifier, ObjectType objectType, SearchCriteria searchCriteria, ObjectClassType containerClassType, ObjectClassType itemClassType, Profile rendererProfile, AccessGroup accessGroup, String idPrefix, int startIndex, int count, boolean disablePresentationSettings) {
        super(contextIdentifier, objectType, searchCriteria, containerClassType, itemClassType, rendererProfile, accessGroup, idPrefix, startIndex, count, disablePresentationSettings);
    }

    @Override
    protected List<Image> retrieveEntityList() {
        List<Image> images = ImageService.getListOfImagesForMonthAndYear(this.getMonth(), this.getYear(), this.accessGroup, this.startIndex, this.count);
        return images;
    }

    @Override
    public int retrieveItemCount() {
        return ImageService.getNumberOfImagesForMonthAndYear(this.getMonth(), this.getYear(), this.accessGroup);
    }

    private Integer getYear() {
        Integer year = Integer.parseInt(this.getInternalObjectId(Definition.instance().getParentNodeId(this.objectId, this.disablePresentationSettings)));
        return year;
    }

    private Integer getMonth() {
        Integer month = Integer.parseInt(this.getInternalObjectId());
        return month;
    }
}

