/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.upnp.service.contentdirectory.command.audio;

import java.util.Collections;
import java.util.List;
import org.serviio.library.entities.AccessGroup;
import org.serviio.library.entities.MusicAlbum;
import org.serviio.library.entities.Person;
import org.serviio.library.local.service.AudioService;
import org.serviio.profile.Profile;
import org.serviio.upnp.service.contentdirectory.ObjectType;
import org.serviio.upnp.service.contentdirectory.SearchCriteria;
import org.serviio.upnp.service.contentdirectory.classes.ClassProperties;
import org.serviio.upnp.service.contentdirectory.classes.ObjectClassType;
import org.serviio.upnp.service.contentdirectory.command.audio.AbstractAlbumsRetrievalCommand;
import org.serviio.util.ObjectValidator;

public class ListAlbumsForArtistNameCommand
extends AbstractAlbumsRetrievalCommand {
    public ListAlbumsForArtistNameCommand(String contextIdentifier, ObjectType objectType, SearchCriteria searchCriteria, ObjectClassType containerClassType, ObjectClassType itemClassType, Profile rendererProfile, AccessGroup accessGroup, String idPrefix, int startIndex, int count, boolean disablePresentationSettings) {
        super(contextIdentifier, objectType, searchCriteria, containerClassType, itemClassType, rendererProfile, accessGroup, idPrefix, startIndex, count, disablePresentationSettings);
    }

    @Override
    protected List<MusicAlbum> retrieveEntityList() {
        String artistName = this.getArtistName();
        if (ObjectValidator.isNotEmpty(artistName)) {
            List<MusicAlbum> albums = AudioService.getListOfAlbumsForTrackRole(artistName, Person.RoleType.ARTIST, this.startIndex, this.count);
            return albums;
        }
        return Collections.emptyList();
    }

    @Override
    public int retrieveItemCount() {
        String artistName = this.getArtistName();
        if (ObjectValidator.isNotEmpty(artistName)) {
            return AudioService.getNumberOfAlbumsForTrackRole(artistName, Person.RoleType.ARTIST);
        }
        return 0;
    }

    private String getArtistName() {
        if (this.searchCriteria != null && this.searchCriteria.getMap().get((Object)ClassProperties.OBJECT_CLASS).equalsIgnoreCase(ObjectClassType.MUSIC_ALBUM.getClassName())) {
            return this.searchCriteria.getMap().get((Object)ClassProperties.ARTIST);
        }
        return null;
    }
}

