/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.upnp.service.contentdirectory.command.audio;

import java.util.List;
import org.serviio.library.entities.AccessGroup;
import org.serviio.library.entities.MusicTrack;
import org.serviio.library.entities.Person;
import org.serviio.library.local.service.AudioService;
import org.serviio.profile.Profile;
import org.serviio.upnp.service.contentdirectory.ObjectType;
import org.serviio.upnp.service.contentdirectory.SearchCriteria;
import org.serviio.upnp.service.contentdirectory.classes.ObjectClassType;
import org.serviio.upnp.service.contentdirectory.command.audio.AbstractSongsRetrievalCommand;
import org.serviio.upnp.service.contentdirectory.definition.Definition;

public abstract class AbstractSongsForRoleAndAlbumRetrievalCommand
extends AbstractSongsRetrievalCommand {
    private Person.RoleType roleType;

    public AbstractSongsForRoleAndAlbumRetrievalCommand(String contextIdentifier, ObjectType objectType, SearchCriteria searchCriteria, ObjectClassType containerClassType, ObjectClassType itemClassType, Profile rendererProfile, AccessGroup accessGroup, String idPrefix, int startIndex, int count, Person.RoleType roleType, boolean disablePresentationSettings) {
        super(contextIdentifier, objectType, searchCriteria, containerClassType, itemClassType, rendererProfile, accessGroup, idPrefix, startIndex, count, disablePresentationSettings);
        this.roleType = roleType;
    }

    @Override
    protected List<MusicTrack> retrieveEntityList() {
        Long artistId = Long.parseLong(this.getInternalObjectId(Definition.instance().getParentNodeId(this.objectId, this.disablePresentationSettings)));
        Long albumId = Long.parseLong(this.getInternalObjectId());
        List<MusicTrack> songs = AudioService.getListOfSongsForTrackRoleAndAlbum(artistId, this.roleType, albumId, this.accessGroup, this.startIndex, this.count);
        return songs;
    }

    @Override
    public int retrieveItemCount() {
        Long artistId = Long.parseLong(this.getInternalObjectId(Definition.instance().getParentNodeId(this.objectId, this.disablePresentationSettings)));
        Long albumId = Long.parseLong(this.getInternalObjectId());
        return AudioService.getNumberOfSongsForTrackRoleAndAlbum(artistId, this.roleType, albumId, this.accessGroup);
    }
}

