/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.upnp.service.contentdirectory.command;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.serviio.delivery.AudioMediaInfo;
import org.serviio.delivery.ImageMediaInfo;
import org.serviio.delivery.MediaResourceRetrievalStrategy;
import org.serviio.delivery.ResourceInfo;
import org.serviio.delivery.VideoMediaInfo;
import org.serviio.delivery.resource.AbstractDeliveryEngine;
import org.serviio.delivery.subtitles.SubtitlesService;
import org.serviio.dlna.MediaFormatProfile;
import org.serviio.dlna.ThumbnailResolution;
import org.serviio.library.entities.CoverImage;
import org.serviio.library.entities.Image;
import org.serviio.library.entities.MediaItem;
import org.serviio.library.entities.MusicTrack;
import org.serviio.library.entities.Video;
import org.serviio.library.local.service.MediaService;
import org.serviio.library.metadata.MediaFileType;
import org.serviio.profile.Profile;
import org.serviio.upnp.service.contentdirectory.classes.Resource;
import org.serviio.util.MediaUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceValuesBuilder {
    private static final Logger log = LoggerFactory.getLogger(ResourceValuesBuilder.class);

    public static final Resource generateSubtitlesResource(Video item, Profile rendererProfile) {
        boolean hardSubsDelivered = AbstractDeliveryEngine.isHardSubsDelivered(rendererProfile.getDefaultDeliveryQuality(), item, rendererProfile);
        if (!hardSubsDelivered && SubtitlesService.isSoftSubsAvailable(item, rendererProfile)) {
            log.debug(String.format("Softsubs for media item %s found, will be served as a resource", item.getId()));
            try {
                Resource subtitle = new Resource(Resource.ResourceType.SUBTITLE, item.getId(), null, null, null, null);
                subtitle.setProtocolInfo(String.format("http-get:*:%s:*", rendererProfile.getSubtitlesConfiguration().getSoftSubsMimeType()));
                return subtitle;
            }
            catch (Exception e) {
                log.debug("Exception while building subtitle resource: " + e.getMessage(), (Throwable)e);
                return null;
            }
        }
        return null;
    }

    public static List<Resource> buildResources(MediaItem entity, Profile rendererProfile) {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        List<? extends ResourceInfo> resourceInfos = MediaResourceRetrievalStrategy.getMediaInfoForAvailableProfiles(entity, rendererProfile);
        if (entity instanceof Image) {
            if (resourceInfos.size() > 0) {
                Image image = (Image)entity;
                for (ResourceInfo resourceInfo : resourceInfos) {
                    ImageMediaInfo imageMediaInfo = (ImageMediaInfo)resourceInfo;
                    Set<String> protocolInfos = rendererProfile.getResourceProtocolInfo(imageMediaInfo.getFormatProfile()).getMediaProtocolInfo(resourceInfo.isTranscoded(), resourceInfo.isLive(), imageMediaInfo.getFormatProfile().getFileType(), false);
                    int i = 0;
                    for (String protocolInfo : protocolInfos) {
                        Resource res = new Resource(Resource.ResourceType.MEDIA_ITEM, image.getId(), imageMediaInfo.getFormatProfile(), i++, imageMediaInfo.getQuality(), resourceInfo.isTranscoded());
                        res.setSize(imageMediaInfo.getFileSize());
                        res.setProtocolInfo(protocolInfo);
                        res.setColorDepth(image.getColorDepth());
                        if (imageMediaInfo.getWidth() != null && imageMediaInfo.getHeight() != null) {
                            res.setResolution(String.format("%sx%s", imageMediaInfo.getWidth(), imageMediaInfo.getHeight()));
                        }
                        resources.add(res);
                    }
                }
                Resource thumbnailResource = ResourceValuesBuilder.generateThumbnailResource(image, rendererProfile);
                if (thumbnailResource != null) {
                    resources.add(1, thumbnailResource);
                }
            }
        } else if (entity instanceof MusicTrack) {
            if (resourceInfos.size() > 0) {
                MusicTrack song = (MusicTrack)entity;
                for (ResourceInfo resourceInfo : resourceInfos) {
                    AudioMediaInfo audioMediaInfo = (AudioMediaInfo)resourceInfo;
                    Set<String> protocolInfos = rendererProfile.getResourceProtocolInfo(audioMediaInfo.getFormatProfile()).getMediaProtocolInfo(audioMediaInfo.isTranscoded(), resourceInfo.isLive(), audioMediaInfo.getFormatProfile().getFileType(), song.getDuration() != null && song.getDuration() > 0);
                    int i = 0;
                    for (String protocolInfo : protocolInfos) {
                        Resource res = new Resource(Resource.ResourceType.MEDIA_ITEM, song.getId(), audioMediaInfo.getFormatProfile(), i++, audioMediaInfo.getQuality(), resourceInfo.isTranscoded());
                        res.setSize(audioMediaInfo.getFileSize());
                        res.setDuration(song.getDuration());
                        res.setProtocolInfo(protocolInfo);
                        res.setBitrate(MediaUtils.convertBitrateFromKbpsToByPS(audioMediaInfo.getBitrate()));
                        res.setSampleFrequency(audioMediaInfo.getSampleFrequency());
                        res.setNrAudioChannels(audioMediaInfo.getChannels());
                        resources.add(res);
                    }
                }
                Resource thumbnailResource = ResourceValuesBuilder.generateThumbnailResource(song, rendererProfile);
                if (thumbnailResource != null) {
                    resources.add(thumbnailResource);
                }
            }
        } else if (entity instanceof Video && resourceInfos.size() > 0) {
            Resource resource;
            Video video = (Video)entity;
            for (ResourceInfo resourceInfo : resourceInfos) {
                VideoMediaInfo videoMediaInfo = (VideoMediaInfo)resourceInfo;
                Set<String> protocolInfos = rendererProfile.getResourceProtocolInfo(videoMediaInfo.getFormatProfile()).getMediaProtocolInfo(videoMediaInfo.isTranscoded(), resourceInfo.isLive(), videoMediaInfo.getFormatProfile().getFileType(), video.getDuration() != null && video.getDuration() > 0);
                int i = 0;
                for (String protocolInfo : protocolInfos) {
                    Resource.ResourceType resourceType = videoMediaInfo.getFormatProfile().isManifestFormat() ? Resource.ResourceType.MANIFEST : Resource.ResourceType.MEDIA_ITEM;
                    Resource res = new Resource(resourceType, video.getId(), videoMediaInfo.getFormatProfile(), i++, videoMediaInfo.getQuality(), resourceInfo.isTranscoded());
                    res.setSize(videoMediaInfo.getFileSize());
                    res.setDuration(video.getDuration());
                    res.setProtocolInfo(protocolInfo);
                    res.setBitrate(MediaUtils.convertBitrateFromKbpsToByPS(videoMediaInfo.getBitrate()));
                    if (videoMediaInfo.getWidth() != null && videoMediaInfo.getHeight() != null) {
                        res.setResolution(String.format("%sx%s", videoMediaInfo.getWidth(), videoMediaInfo.getHeight()));
                    }
                    resources.add(res);
                }
            }
            Resource thumbnailResource = ResourceValuesBuilder.generateThumbnailResource(video, rendererProfile);
            if (thumbnailResource != null) {
                resources.add(thumbnailResource);
            }
            if ((resource = ResourceValuesBuilder.generateSubtitlesResource(video, rendererProfile)) != null) {
                resources.add(resource);
            }
        }
        return resources;
    }

    public static final Resource generateThumbnailResource(Long entityId, Long thumbnailId, Profile rendererProfile, boolean isLocalThubmnail) {
        if (thumbnailId != null) {
            try {
                Resource thRes = null;
                if (isLocalThubmnail) {
                    CoverImage thumbnail = MediaService.getCoverImage(thumbnailId);
                    thRes = new Resource(Resource.ResourceType.COVER_IMAGE, thumbnail.getId(), null, null, null, null);
                    if (rendererProfile != null && rendererProfile.getThumbnailsResolution() == ThumbnailResolution.HD) {
                        thRes.setResolution(String.format("%sx%s", thumbnail.getWidthHD(), thumbnail.getHeightHD()));
                    } else {
                        thRes.setResolution(String.format("%sx%s", thumbnail.getWidth(), thumbnail.getHeight()));
                    }
                } else {
                    thRes = new Resource(Resource.ResourceType.COVER_IMAGE, entityId, null, null, null, null);
                }
                if (rendererProfile != null) {
                    String protocolInfos = rendererProfile.getResourceProtocolInfo(MediaFormatProfile.JPEG_TN).getMediaProtocolInfo(true, false, MediaFileType.IMAGE, false).iterator().next();
                    thRes.setProtocolInfo(protocolInfos);
                }
                return thRes;
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public static final Resource generateThumbnailResource(MediaItem item, Profile rendererProfile) {
        return ResourceValuesBuilder.generateThumbnailResource(item.getId(), item.getThumbnailId(), rendererProfile, item.isLocalMedia());
    }

    public static final Resource generateThumbnailResource(Long thumbnailId) {
        if (thumbnailId != null) {
            try {
                return new Resource(Resource.ResourceType.COVER_IMAGE, thumbnailId, null, null, null, null);
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }
}

