/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.upnp.service.contentdirectory.command;

import java.util.HashMap;
import java.util.Map;
import org.serviio.db.entities.PersistedEntity;
import org.serviio.library.entities.AccessGroup;
import org.serviio.library.entities.Folder;
import org.serviio.library.entities.Genre;
import org.serviio.library.entities.Image;
import org.serviio.library.entities.MediaItem;
import org.serviio.library.entities.MusicAlbum;
import org.serviio.library.entities.MusicTrack;
import org.serviio.library.entities.OnlineRepository;
import org.serviio.library.entities.Person;
import org.serviio.library.entities.Playlist;
import org.serviio.library.entities.Repository;
import org.serviio.library.entities.Series;
import org.serviio.library.entities.Video;
import org.serviio.library.local.service.AudioService;
import org.serviio.library.local.service.CoverImageService;
import org.serviio.library.local.service.FolderService;
import org.serviio.library.local.service.GenreService;
import org.serviio.library.local.service.PersonService;
import org.serviio.library.metadata.MediaFileType;
import org.serviio.profile.Profile;
import org.serviio.upnp.service.contentdirectory.ObjectType;
import org.serviio.upnp.service.contentdirectory.SearchCriteria;
import org.serviio.upnp.service.contentdirectory.classes.ClassProperties;
import org.serviio.upnp.service.contentdirectory.classes.Resource;
import org.serviio.upnp.service.contentdirectory.command.ResourceValuesBuilder;
import org.serviio.upnp.service.contentdirectory.definition.Definition;
import org.serviio.util.CollectionUtils;
import org.serviio.util.DateUtils;

public class ObjectValuesBuilder {
    public static Map<ClassProperties, Object> buildObjectValues(PersistedEntity entity, String objectId, String parentId, ObjectType objectType, SearchCriteria searchCriteria, String title, Profile rendererProfile, AccessGroup accessGroup, MediaFileType fileType, boolean disablePresentationSettings) {
        Map<ClassProperties, Object> values = null;
        if (entity instanceof Folder) {
            Long coverImageId = CoverImageService.getFolderCoverArt(entity.getId(), fileType);
            values = ObjectValuesBuilder.instantiateValuesForContainer(title, objectId, parentId, objectType, searchCriteria, accessGroup, coverImageId, disablePresentationSettings);
        } else if (entity instanceof Person) {
            Person person = (Person)entity;
            Long thumbnailId = null;
            if (!person.getName().equals("Unknown")) {
                thumbnailId = CoverImageService.getPersonCoverArt(person.getId());
            }
            values = ObjectValuesBuilder.instantiateValuesForContainer(title, objectId, parentId, objectType, searchCriteria, accessGroup, thumbnailId, disablePresentationSettings);
        } else if (entity instanceof Playlist) {
            values = ObjectValuesBuilder.instantiateValuesForContainer(title, objectId, parentId, objectType, searchCriteria, accessGroup, null, disablePresentationSettings);
        } else if (entity instanceof Genre) {
            values = ObjectValuesBuilder.instantiateValuesForContainer(title, objectId, parentId, objectType, searchCriteria, accessGroup, null, disablePresentationSettings);
        } else if (entity instanceof Series) {
            Series series = (Series)entity;
            values = ObjectValuesBuilder.instantiateValuesForContainer(title, objectId, parentId, objectType, searchCriteria, accessGroup, series.getThumbnailId(), disablePresentationSettings);
        } else if (entity instanceof MusicAlbum) {
            MusicAlbum album = (MusicAlbum)entity;
            Long albumArtId = CoverImageService.getMusicAlbumCoverArt(album.getId());
            values = ObjectValuesBuilder.instantiateValuesForContainer(title, objectId, parentId, objectType, searchCriteria, accessGroup, albumArtId, disablePresentationSettings);
            Person albumArtist = (Person)CollectionUtils.getFirstItem(PersonService.getListOfPersonsForMusicAlbum(album.getId(), Person.RoleType.ALBUM_ARTIST));
            if (albumArtist != null) {
                values.put(ClassProperties.ARTIST, albumArtist.getName());
            }
        } else if (entity instanceof Image) {
            Image image = (Image)entity;
            values = ObjectValuesBuilder.instantiateValuesForItem(title, objectId, parentId, image, disablePresentationSettings);
            values.put(ClassProperties.DATE, DateUtils.formatISO8601YYYYMMDD(image.getDate()));
            values.put(ClassProperties.DESCRIPTION, image.getDescription());
            if (image.isLocalMedia()) {
                values.put(ClassProperties.ALBUM, FolderService.getFolder(image.getFolderId()).getName());
            }
        } else if (entity instanceof MusicTrack) {
            MusicTrack track = (MusicTrack)entity;
            values = ObjectValuesBuilder.instantiateValuesForItem(title, objectId, parentId, track, disablePresentationSettings);
            values.put(ClassProperties.ALBUM, AudioService.getMusicAlbum(track.getAlbumId()));
            values.put(ClassProperties.GENRE, GenreService.getGenre(track.getGenreId()));
            if (track.isLocalMedia()) {
                Person artist = (Person)CollectionUtils.getFirstItem(PersonService.getListOfPersonsForMediaItem(track.getId(), Person.RoleType.ARTIST));
                values.put(ClassProperties.CREATOR, artist);
                values.put(ClassProperties.ARTIST, artist);
            }
            values.put(ClassProperties.DATE, DateUtils.formatISO8601YYYYMMDD(track.getDate()));
            values.put(ClassProperties.ORIGINAL_TRACK_NUMBER, track.getTrackNumber());
            values.put(ClassProperties.DESCRIPTION, track.getDescription());
            values.put(ClassProperties.LIVE, track.isLive());
        } else if (entity instanceof Video) {
            Video video = (Video)entity;
            values = ObjectValuesBuilder.instantiateValuesForItem(title, objectId, parentId, video, disablePresentationSettings);
            values.put(ClassProperties.RATING, (Object)video.getRating());
            values.put(ClassProperties.DESCRIPTION, video.getDescription());
            values.put(ClassProperties.DATE, DateUtils.formatISO8601YYYYMMDD(video.getDate()));
            values.put(ClassProperties.LIVE, video.isLive());
            values.put(ClassProperties.ONLINE_DB_IDENTIFIERS, video.getOnlineIdentifiers());
            values.put(ClassProperties.CONTENT_TYPE, (Object)video.getContentType());
            values.put(ClassProperties.SUBTITLES_URL, ResourceValuesBuilder.generateSubtitlesResource(video, rendererProfile));
            if (video.isLocalMedia()) {
                values.put(ClassProperties.GENRE, GenreService.getGenre(video.getGenreId()));
            }
        } else if (entity instanceof Repository) {
            Long coverImageId = CoverImageService.getRepositoryCoverArt(entity.getId(), fileType);
            values = ObjectValuesBuilder.instantiateValuesForContainer(title, objectId, parentId, objectType, searchCriteria, accessGroup, coverImageId, disablePresentationSettings);
        } else if (entity instanceof OnlineRepository) {
            values = ObjectValuesBuilder.instantiateValuesForContainer(title, objectId, parentId, objectType, searchCriteria, accessGroup, null, disablePresentationSettings);
        } else {
            return null;
        }
        if (rendererProfile.getContentDirectoryDefinitionFilter() != null) {
            rendererProfile.getContentDirectoryDefinitionFilter().filterClassProperties(objectId, values);
        }
        return values;
    }

    public static Map<ClassProperties, Object> instantiateValuesForContainer(String containerTitle, String objectId, String parentId, ObjectType objectType, SearchCriteria searchCriteria, AccessGroup accessGroup, Long containerThumbnailId, boolean disablePresentationSettings) {
        HashMap<ClassProperties, Object> values = new HashMap<ClassProperties, Object>();
        values.put(ClassProperties.ID, objectId);
        values.put(ClassProperties.TITLE, ObjectValuesBuilder.getBrowsableTitle(containerTitle, objectId, disablePresentationSettings));
        values.put(ClassProperties.PARENT_ID, parentId);
        values.put(ClassProperties.CHILD_COUNT, Definition.instance().getContainer(objectId).retrieveContainerItemsCount(objectId, objectType, searchCriteria, accessGroup, disablePresentationSettings));
        values.put(ClassProperties.SEARCHABLE, Boolean.FALSE);
        if (containerThumbnailId != null) {
            Resource icon = ResourceValuesBuilder.generateThumbnailResource(containerThumbnailId);
            values.put(ClassProperties.ICON, icon);
            values.put(ClassProperties.ALBUM_ART_URI, icon);
        }
        return values;
    }

    public static Map<ClassProperties, Object> instantiateValuesForItem(String itemTitle, String objectId, String parentId, MediaItem item, boolean disablePresentationSettings) {
        HashMap<ClassProperties, Object> values = new HashMap<ClassProperties, Object>();
        Resource icon = ResourceValuesBuilder.generateThumbnailResource(item.getThumbnailId());
        values.put(ClassProperties.ID, objectId);
        values.put(ClassProperties.TITLE, ObjectValuesBuilder.getBrowsableTitle(itemTitle, objectId, disablePresentationSettings));
        values.put(ClassProperties.PARENT_ID, parentId);
        values.put(ClassProperties.ICON, icon);
        values.put(ClassProperties.ALBUM_ART_URI, icon);
        values.put(ClassProperties.DCM_INFO, ObjectValuesBuilder.generateDcmInfo(item));
        return values;
    }

    protected static final String generateDcmInfo(MediaItem item) {
        if (item.getBookmark() != null) {
            return String.format("CREATIONDATE=0,YEAR=%s,BM=%s", DateUtils.getYear(item.getDate()), item.getBookmark());
        }
        return null;
    }

    private static String getBrowsableTitle(String itemTitle, String objectId, boolean disablePresentationSettings) {
        String parentsTitle = Definition.instance().getContentOnlyParentTitles(objectId, disablePresentationSettings);
        if (parentsTitle != null) {
            return String.format("%s %s", itemTitle, parentsTitle);
        }
        return itemTitle;
    }
}

