/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.upnp.service.contentdirectory.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.serviio.library.entities.AccessGroup;
import org.serviio.library.metadata.MediaFileType;
import org.serviio.profile.Profile;
import org.serviio.upnp.service.contentdirectory.ObjectType;
import org.serviio.upnp.service.contentdirectory.SearchCriteria;
import org.serviio.upnp.service.contentdirectory.classes.ClassProperties;
import org.serviio.upnp.service.contentdirectory.classes.Container;
import org.serviio.upnp.service.contentdirectory.classes.DirectoryObjectBuilder;
import org.serviio.upnp.service.contentdirectory.classes.ObjectClassType;
import org.serviio.upnp.service.contentdirectory.command.AbstractCommand;
import org.serviio.upnp.service.contentdirectory.command.ObjectValuesBuilder;
import org.serviio.upnp.service.contentdirectory.definition.Definition;

public abstract class AbstractListYearsCommand
extends AbstractCommand<Container> {
    public AbstractListYearsCommand(String contextIdentifier, ObjectType objectType, SearchCriteria searchCriteria, ObjectClassType containerClassType, ObjectClassType itemClassType, Profile rendererProfile, AccessGroup accessGroup, MediaFileType fileType, String idPrefix, int startIndex, int count, boolean disablePresentationSettings) {
        super(contextIdentifier, objectType, searchCriteria, containerClassType, itemClassType, rendererProfile, accessGroup, fileType, idPrefix, startIndex, count, disablePresentationSettings);
    }

    protected abstract List<Integer> getListOfYears(AccessGroup var1, int var2, int var3);

    @Override
    protected Set<ObjectClassType> getSupportedClasses() {
        return new HashSet<ObjectClassType>(Arrays.asList(ObjectClassType.CONTAINER, ObjectClassType.STORAGE_FOLDER));
    }

    @Override
    protected Set<ObjectType> getSupportedObjectTypes() {
        return ObjectType.getContainerTypes();
    }

    @Override
    protected List<Container> retrieveList() {
        ArrayList<Container> items = new ArrayList<Container>();
        List<Integer> years = this.getListOfYears(this.accessGroup, this.startIndex, this.count);
        for (Integer year : years) {
            String runtimeId = this.generateRuntimeObjectId(year);
            Map<ClassProperties, Object> values = ObjectValuesBuilder.instantiateValuesForContainer(year.toString(), runtimeId, this.getDisplayedContainerId(this.objectId), this.objectType, this.searchCriteria, this.accessGroup, null, this.disablePresentationSettings);
            items.add((Container)DirectoryObjectBuilder.createInstance(this.containerClassType, values, null, null, this.disablePresentationSettings));
        }
        return items;
    }

    @Override
    protected Container retrieveSingleItem() {
        Map<ClassProperties, Object> values = ObjectValuesBuilder.instantiateValuesForContainer(this.getInternalObjectId(), this.objectId, Definition.instance().getParentNodeId(this.objectId, this.disablePresentationSettings), this.objectType, this.searchCriteria, this.accessGroup, null, this.disablePresentationSettings);
        return (Container)DirectoryObjectBuilder.createInstance(this.containerClassType, values, null, null, this.disablePresentationSettings);
    }
}

