/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.upnp.service.contentdirectory.command;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.serviio.library.entities.AccessGroup;
import org.serviio.library.entities.Playlist;
import org.serviio.library.local.service.PlaylistService;
import org.serviio.library.metadata.MediaFileType;
import org.serviio.profile.Profile;
import org.serviio.upnp.service.contentdirectory.ObjectType;
import org.serviio.upnp.service.contentdirectory.SearchCriteria;
import org.serviio.upnp.service.contentdirectory.classes.ObjectClassType;
import org.serviio.upnp.service.contentdirectory.command.AbstractEntityContainerCommand;

public abstract class AbstractListPlaylistsCommand
extends AbstractEntityContainerCommand<Playlist> {
    public AbstractListPlaylistsCommand(String objectId, ObjectType objectType, SearchCriteria searchCriteria, ObjectClassType containerClassType, ObjectClassType itemClassType, Profile rendererProfile, AccessGroup accessGroup, MediaFileType fileType, String idPrefix, int startIndex, int count, boolean disablePresentationSettings) {
        super(objectId, objectType, searchCriteria, containerClassType, itemClassType, rendererProfile, accessGroup, fileType, idPrefix, startIndex, count, disablePresentationSettings);
    }

    @Override
    protected Set<ObjectClassType> getSupportedClasses() {
        return new HashSet<ObjectClassType>(Arrays.asList(ObjectClassType.CONTAINER, ObjectClassType.STORAGE_FOLDER, ObjectClassType.PLAYLIST_CONTAINER));
    }

    @Override
    protected List<Playlist> retrieveEntityList() {
        List<Playlist> playlists = PlaylistService.getListOfPlaylistsWithMedia(this.fileType, this.accessGroup, this.startIndex, this.count);
        return playlists;
    }

    @Override
    protected Playlist retrieveSingleEntity(Long entityId) {
        Playlist playlist = PlaylistService.getPlaylist(entityId);
        return playlist;
    }

    @Override
    public int retrieveItemCount() {
        return PlaylistService.getNumberOfPlaylistsWithMedia(this.fileType, this.accessGroup);
    }

    @Override
    protected String getContainerTitle(Playlist playlist) {
        return playlist.getTitle();
    }
}

