/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.upnp.service.contentdirectory.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.serviio.library.entities.AccessGroup;
import org.serviio.library.entities.MediaItem;
import org.serviio.library.metadata.MediaFileType;
import org.serviio.library.online.OnlineItemService;
import org.serviio.library.online.metadata.NamedOnlineResource;
import org.serviio.library.online.metadata.OnlineItem;
import org.serviio.library.online.metadata.OnlineResourceContainer;
import org.serviio.profile.Profile;
import org.serviio.upnp.service.contentdirectory.ObjectNotFoundException;
import org.serviio.upnp.service.contentdirectory.ObjectType;
import org.serviio.upnp.service.contentdirectory.SearchCriteria;
import org.serviio.upnp.service.contentdirectory.classes.ClassProperties;
import org.serviio.upnp.service.contentdirectory.classes.DirectoryObject;
import org.serviio.upnp.service.contentdirectory.classes.DirectoryObjectBuilder;
import org.serviio.upnp.service.contentdirectory.classes.ObjectClassType;
import org.serviio.upnp.service.contentdirectory.classes.Resource;
import org.serviio.upnp.service.contentdirectory.command.AbstractCommand;
import org.serviio.upnp.service.contentdirectory.command.CommandExecutionException;
import org.serviio.upnp.service.contentdirectory.command.NonRecursiveIdGenerator;
import org.serviio.upnp.service.contentdirectory.command.ObjectValuesBuilder;
import org.serviio.upnp.service.contentdirectory.command.OnlineRecursiveIdGenerator;
import org.serviio.upnp.service.contentdirectory.command.ResourceValuesBuilder;
import org.serviio.upnp.service.contentdirectory.definition.Definition;

public abstract class AbstractListOnlineObjectsByHierarchyCommand
extends AbstractCommand<DirectoryObject> {
    public AbstractListOnlineObjectsByHierarchyCommand(String objectId, ObjectType objectType, SearchCriteria searchCriteria, ObjectClassType containerClassType, ObjectClassType itemClassType, Profile rendererProfile, AccessGroup accessGroup, MediaFileType fileType, String idPrefix, int startIndex, int count, boolean disablePresentationSettings) {
        super(objectId, objectType, searchCriteria, containerClassType, itemClassType, rendererProfile, accessGroup, fileType, idPrefix, startIndex, count, disablePresentationSettings);
    }

    @Override
    protected Set<ObjectClassType> getSupportedClasses() {
        return new HashSet<ObjectClassType>(Arrays.asList(ObjectClassType.values()));
    }

    @Override
    protected Set<ObjectType> getSupportedObjectTypes() {
        return ObjectType.getAllTypes();
    }

    @Override
    protected List<DirectoryObject> retrieveList() {
        ArrayList<DirectoryObject> objects = new ArrayList<DirectoryObject>();
        Long folderId = this.getFolderId();
        int returnedFoldersCount = 0;
        int existingFoldersCount = 0;
        if (this.objectType.supportsContainers()) {
            int n = existingFoldersCount = folderId == null ? OnlineItemService.getCountOfParsedFeeds(this.fileType, this.accessGroup, true) : 0;
            if (this.startIndex < existingFoldersCount) {
                List<NamedOnlineResource<OnlineResourceContainer<?, ?>>> resources = OnlineItemService.getListOfParsedContainerResources(this.fileType, this.accessGroup, this.startIndex, this.count, true);
                for (NamedOnlineResource<OnlineResourceContainer<?, ?>> folder : resources) {
                    OnlineResourceContainer<?, ?> resource = folder.getOnlineItem();
                    String runtimeId = this.generateFolderObjectId(resource.getOnlineRepositoryId());
                    Map<ClassProperties, Object> values = ObjectValuesBuilder.buildObjectValues(resource.toOnlineRepository(), runtimeId, this.getDisplayedContainerId(this.objectId), this.objectType, this.searchCriteria, resource.getDisplayName(folder.getRepositoryName()), this.rendererProfile, this.accessGroup, this.fileType, this.disablePresentationSettings);
                    objects.add(DirectoryObjectBuilder.createInstance(this.containerClassType, values, null, resource.getOnlineRepositoryId(), this.disablePresentationSettings));
                }
                returnedFoldersCount = resources.size();
            }
        }
        if (this.count > returnedFoldersCount && this.objectType.supportsItems()) {
            int itemStartIndex = this.startIndex - existingFoldersCount + returnedFoldersCount;
            List<NamedOnlineResource<OnlineItem>> items = this.getItemsForMediaType(folderId, itemStartIndex, this.count - returnedFoldersCount);
            for (NamedOnlineResource<OnlineItem> namedItem : items) {
                OnlineItem item = namedItem.getOnlineItem();
                String runtimeId = this.generateItemObjectId(item.getId());
                MediaItem mediaItem = item.toMediaItem();
                Map<ClassProperties, Object> values = ObjectValuesBuilder.buildObjectValues(mediaItem, runtimeId, this.getDisplayedContainerId(this.objectId), this.objectType, this.searchCriteria, item.getDisplayTitle(namedItem.getRepositoryName()), this.rendererProfile, this.accessGroup, this.fileType, this.disablePresentationSettings);
                List<Resource> res = ResourceValuesBuilder.buildResources(mediaItem, this.rendererProfile);
                objects.add(DirectoryObjectBuilder.createInstance(this.itemClassType, values, res, item.getId(), this.disablePresentationSettings));
            }
        }
        return objects;
    }

    @Override
    protected DirectoryObject retrieveSingleItem() {
        Long itemId = this.getMediaItemId();
        if (itemId != null) {
            NamedOnlineResource<OnlineItem> namedItem = this.getItem(itemId);
            if (namedItem != null) {
                OnlineItem item = namedItem.getOnlineItem();
                MediaItem mediaItem = item.toMediaItem();
                Map<ClassProperties, Object> values = ObjectValuesBuilder.buildObjectValues(mediaItem, this.objectId, OnlineRecursiveIdGenerator.getRecursiveParentId(this.objectId), this.objectType, this.searchCriteria, item.getDisplayTitle(namedItem.getRepositoryName()), this.rendererProfile, this.accessGroup, this.fileType, this.disablePresentationSettings);
                List<Resource> res = ResourceValuesBuilder.buildResources(mediaItem, this.rendererProfile);
                return DirectoryObjectBuilder.createInstance(this.itemClassType, values, res, itemId, this.disablePresentationSettings);
            }
            throw new ObjectNotFoundException(String.format("OnlineItem with id %s not found in CDS", itemId));
        }
        Long folderId = this.getFolderId();
        if (folderId != null) {
            NamedOnlineResource<OnlineResourceContainer<?, ?>> resource = OnlineItemService.findNamedContainerResourceById(folderId);
            if (resource != null) {
                OnlineResourceContainer<?, ?> feed = resource.getOnlineItem();
                Map<ClassProperties, Object> values = ObjectValuesBuilder.buildObjectValues(feed.toOnlineRepository(), this.objectId, Definition.instance().getParentNodeId(this.objectId, this.disablePresentationSettings), this.objectType, this.searchCriteria, feed.getDisplayName(resource.getRepositoryName()), this.rendererProfile, this.accessGroup, this.fileType, this.disablePresentationSettings);
                return DirectoryObjectBuilder.createInstance(this.containerClassType, values, null, folderId, this.disablePresentationSettings);
            }
            throw new ObjectNotFoundException(String.format("Folder with id %s not found in CDS", folderId));
        }
        throw new ObjectNotFoundException(String.format("Error retrieving object %s from CDS", this.objectId));
    }

    @Override
    public int retrieveItemCount() throws CommandExecutionException {
        return OnlineItemService.getCountOfOnlineItemsAndRepositories(this.fileType, this.objectType, this.getFolderId(), this.accessGroup, true);
    }

    private String generateFolderObjectId(Number entityId) {
        return OnlineRecursiveIdGenerator.generateFolderObjectId(entityId, this.objectId, this.idPrefix);
    }

    private String generateItemObjectId(Number entityId) {
        if (this.objectId.indexOf("^") == -1) {
            return NonRecursiveIdGenerator.generateId(this.objectId, this.idPrefix, "$OI" + entityId.toString());
        }
        return OnlineRecursiveIdGenerator.generateItemObjectId(entityId, this.objectId, this.idPrefix);
    }

    private Long getFolderId() {
        if (this.objectId.indexOf("FD") > -1) {
            String strippedId = this.objectId.substring(this.objectId.indexOf("FD"));
            if (strippedId.indexOf("$") > -1) {
                strippedId = strippedId.substring(0, strippedId.indexOf("$"));
            }
            return Long.parseLong(strippedId.substring("FD".length()));
        }
        return null;
    }

    private Long getMediaItemId() {
        String itemPrefix = "$OI";
        if (this.objectId.indexOf(itemPrefix) > -1) {
            String strippedId = this.objectId.substring(this.objectId.lastIndexOf(itemPrefix));
            return Long.parseLong(strippedId.substring(itemPrefix.length()));
        }
        return null;
    }

    private List<NamedOnlineResource<OnlineItem>> getItemsForMediaType(Long folderId, int startIndex, int count) {
        if (folderId == null) {
            return OnlineItemService.getListOfSingleURLItems(this.fileType, this.accessGroup, startIndex, count, true);
        }
        OnlineResourceContainer<?, ?> cachedContainerResource = OnlineItemService.findContainerResourceById(folderId);
        return OnlineItemService.getListOfFeedItems(cachedContainerResource, this.fileType, startIndex, count);
    }

    private NamedOnlineResource<OnlineItem> getItem(Long itemId) {
        return OnlineItemService.findNamedOnlineItemById(itemId);
    }
}

