/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.upnp.service.contentdirectory.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.serviio.library.entities.AccessGroup;
import org.serviio.library.entities.Folder;
import org.serviio.library.entities.MediaItem;
import org.serviio.library.entities.Repository;
import org.serviio.library.local.service.AudioService;
import org.serviio.library.local.service.FolderService;
import org.serviio.library.local.service.ImageService;
import org.serviio.library.local.service.RepositoryService;
import org.serviio.library.local.service.VideoService;
import org.serviio.library.metadata.MediaFileType;
import org.serviio.profile.Profile;
import org.serviio.upnp.service.contentdirectory.ObjectNotFoundException;
import org.serviio.upnp.service.contentdirectory.ObjectType;
import org.serviio.upnp.service.contentdirectory.SearchCriteria;
import org.serviio.upnp.service.contentdirectory.classes.ClassProperties;
import org.serviio.upnp.service.contentdirectory.classes.DirectoryObject;
import org.serviio.upnp.service.contentdirectory.classes.DirectoryObjectBuilder;
import org.serviio.upnp.service.contentdirectory.classes.ObjectClassType;
import org.serviio.upnp.service.contentdirectory.classes.Resource;
import org.serviio.upnp.service.contentdirectory.command.AbstractCommand;
import org.serviio.upnp.service.contentdirectory.command.CommandExecutionException;
import org.serviio.upnp.service.contentdirectory.command.ObjectValuesBuilder;
import org.serviio.upnp.service.contentdirectory.command.RecursiveIdGenerator;
import org.serviio.upnp.service.contentdirectory.command.ResourceValuesBuilder;
import org.serviio.upnp.service.contentdirectory.definition.Definition;

public abstract class AbstractListObjectsByFSHierarchyCommand
extends AbstractCommand<DirectoryObject> {
    public AbstractListObjectsByFSHierarchyCommand(String objectId, ObjectType objectType, SearchCriteria searchCriteria, ObjectClassType containerClassType, ObjectClassType itemClassType, Profile rendererProfile, AccessGroup accessGroup, MediaFileType fileType, String idPrefix, int startIndex, int count, boolean disablePresentationSettings) {
        super(objectId, objectType, searchCriteria, containerClassType, itemClassType, rendererProfile, accessGroup, fileType, idPrefix, startIndex, count, disablePresentationSettings);
    }

    @Override
    protected Set<ObjectClassType> getSupportedClasses() {
        return new HashSet<ObjectClassType>(Arrays.asList(ObjectClassType.values()));
    }

    @Override
    protected Set<ObjectType> getSupportedObjectTypes() {
        return ObjectType.getAllTypes();
    }

    @Override
    protected List<DirectoryObject> retrieveList() {
        ArrayList<DirectoryObject> objects;
        block8: {
            Long repositoryId;
            block7: {
                objects = new ArrayList<DirectoryObject>();
                repositoryId = this.getRepositoryId();
                if (repositoryId != null) break block7;
                if (!this.objectType.supportsContainers()) break block8;
                List<Repository> repositories = RepositoryService.getListOfRepositories(this.fileType, this.accessGroup, this.startIndex, this.count);
                for (Repository repository : repositories) {
                    String runtimeId = this.generateRepositoryObjectId(repository.getId());
                    Map<ClassProperties, Object> values = ObjectValuesBuilder.buildObjectValues(repository, runtimeId, this.getDisplayedContainerId(this.objectId), this.objectType, this.searchCriteria, repository.getRepositoryName(), this.rendererProfile, this.accessGroup, this.fileType, this.disablePresentationSettings);
                    objects.add(DirectoryObjectBuilder.createInstance(this.containerClassType, values, this.getContainerResources(values, repository.getId(), this.rendererProfile), repository.getId(), this.disablePresentationSettings));
                }
                break block8;
            }
            Long folderId = this.getFolderId();
            int returnedFoldersCount = 0;
            int existingFoldersCount = 0;
            if (this.objectType.supportsContainers() && this.startIndex < (existingFoldersCount = FolderService.getNumberOfSubfolders(folderId, repositoryId, this.accessGroup))) {
                List<Folder> folders = FolderService.getListOfSubFolders(folderId, repositoryId, this.accessGroup, this.startIndex, this.count);
                for (Folder folder : folders) {
                    String string = this.generateFolderObjectId(folder.getId());
                    Map<ClassProperties, Object> values = ObjectValuesBuilder.buildObjectValues(folder, string, this.getDisplayedContainerId(this.objectId), this.objectType, this.searchCriteria, folder.getName(), this.rendererProfile, this.accessGroup, this.fileType, this.disablePresentationSettings);
                    objects.add(DirectoryObjectBuilder.createInstance(this.containerClassType, values, this.getContainerResources(values, folder.getId(), this.rendererProfile), folder.getId(), this.disablePresentationSettings));
                }
                returnedFoldersCount = folders.size();
            }
            if (this.count > returnedFoldersCount && this.objectType.supportsItems()) {
                if (folderId == null) {
                    folderId = FolderService.retrieveVirtualFolderId(repositoryId);
                }
                if (folderId != null) {
                    int itemStartIndex = this.startIndex - existingFoldersCount + returnedFoldersCount;
                    List<? extends MediaItem> items = this.getItemsForMediaType(folderId, itemStartIndex, this.count - returnedFoldersCount);
                    for (MediaItem mediaItem : items) {
                        String runtimeId = this.generateItemObjectId(mediaItem.getId());
                        Map<ClassProperties, Object> values = ObjectValuesBuilder.buildObjectValues(mediaItem, runtimeId, this.getDisplayedContainerId(this.objectId), this.objectType, this.searchCriteria, this.getItemTitle(mediaItem), this.rendererProfile, this.accessGroup, this.fileType, this.disablePresentationSettings);
                        List<Resource> res = ResourceValuesBuilder.buildResources(mediaItem, this.rendererProfile);
                        objects.add(DirectoryObjectBuilder.createInstance(this.itemClassType, values, res, mediaItem.getId(), this.disablePresentationSettings));
                    }
                }
            }
        }
        return objects;
    }

    @Override
    protected DirectoryObject retrieveSingleItem() {
        Long itemId = this.getMediaItemId();
        if (itemId != null) {
            MediaItem item = this.getItem(itemId);
            if (item != null) {
                Map<ClassProperties, Object> values = ObjectValuesBuilder.buildObjectValues(item, this.objectId, RecursiveIdGenerator.getRecursiveParentId(this.objectId), this.objectType, this.searchCriteria, this.getItemTitle(item), this.rendererProfile, this.accessGroup, this.fileType, this.disablePresentationSettings);
                List<Resource> res = ResourceValuesBuilder.buildResources(item, this.rendererProfile);
                return DirectoryObjectBuilder.createInstance(this.itemClassType, values, res, itemId, this.disablePresentationSettings);
            }
            throw new ObjectNotFoundException(String.format("MediaItem with id %s not found in CDS", itemId));
        }
        Long folderId = this.getFolderId();
        if (folderId != null) {
            Folder folder = FolderService.getFolder(folderId);
            if (folder != null) {
                Map<ClassProperties, Object> values = ObjectValuesBuilder.buildObjectValues(folder, this.objectId, RecursiveIdGenerator.getRecursiveParentId(this.objectId), this.objectType, this.searchCriteria, folder.getName(), this.rendererProfile, this.accessGroup, this.fileType, this.disablePresentationSettings);
                return DirectoryObjectBuilder.createInstance(this.containerClassType, values, this.getContainerResources(values, folderId, this.rendererProfile), folderId, this.disablePresentationSettings);
            }
            throw new ObjectNotFoundException(String.format("Folder with id %s not found in CDS", folderId));
        }
        Long repositoryId = this.getRepositoryId();
        Repository repository = RepositoryService.getRepository(repositoryId);
        if (repository != null) {
            Map<ClassProperties, Object> values = ObjectValuesBuilder.buildObjectValues(repository, this.objectId, Definition.instance().getParentNodeId(this.objectId, this.disablePresentationSettings), this.objectType, this.searchCriteria, repository.getRepositoryName(), this.rendererProfile, this.accessGroup, this.fileType, this.disablePresentationSettings);
            return DirectoryObjectBuilder.createInstance(this.containerClassType, values, this.getContainerResources(values, repositoryId, this.rendererProfile), repositoryId, this.disablePresentationSettings);
        }
        throw new ObjectNotFoundException(String.format("Repository with id %s not found in CDS", this.objectId));
    }

    @Override
    public int retrieveItemCount() throws CommandExecutionException {
        Long repositoryId = this.getRepositoryId();
        if (repositoryId == null) {
            return this.objectType.supportsContainers() ? RepositoryService.getNumberOfRepositories(this.fileType, this.accessGroup) : 0;
        }
        return FolderService.getNumberOfFoldersAndMediaItems(this.fileType, this.objectType, this.accessGroup, this.getFolderId(), repositoryId);
    }

    private String generateRepositoryObjectId(Number entityId) {
        return RecursiveIdGenerator.generateRepositoryObjectId(entityId, this.objectId, this.idPrefix);
    }

    private String generateFolderObjectId(Number entityId) {
        return RecursiveIdGenerator.generateFolderObjectId(entityId, this.objectId);
    }

    private String generateItemObjectId(Number entityId) {
        return RecursiveIdGenerator.generateItemObjectId(entityId, this.objectId);
    }

    private Long getFolderId() {
        String folderPrefix = "$F";
        if (this.objectId.indexOf(folderPrefix) > -1) {
            String strippedId = this.objectId.substring(this.objectId.lastIndexOf(folderPrefix));
            return Long.parseLong(strippedId.substring(folderPrefix.length()));
        }
        return null;
    }

    private Long getMediaItemId() {
        String itemPrefix = "$MI";
        if (this.objectId.indexOf(itemPrefix) > -1) {
            String strippedId = this.objectId.substring(this.objectId.lastIndexOf(itemPrefix));
            return Long.parseLong(strippedId.substring(itemPrefix.length()));
        }
        return null;
    }

    private Long getRepositoryId() {
        if (this.objectId.indexOf("R") > -1) {
            String strippedId = this.objectId.substring(this.objectId.indexOf("R"));
            if (strippedId.indexOf("$") > -1) {
                strippedId = strippedId.substring(0, strippedId.indexOf("$"));
            }
            return Long.parseLong(strippedId.substring("R".length()));
        }
        return null;
    }

    private List<? extends MediaItem> getItemsForMediaType(Long folderId, int startIndex, int count) {
        if (this.fileType == MediaFileType.AUDIO) {
            return AudioService.getListOfSongsForFolder(folderId, this.accessGroup, startIndex, count);
        }
        if (this.fileType == MediaFileType.IMAGE) {
            return ImageService.getListOfImagesForFolder(folderId, this.accessGroup, startIndex, count);
        }
        if (this.fileType == MediaFileType.VIDEO) {
            return VideoService.getListOfVideosForFolder(folderId, this.accessGroup, startIndex, count);
        }
        return Collections.emptyList();
    }

    private MediaItem getItem(Long itemId) {
        if (this.fileType == MediaFileType.AUDIO) {
            return AudioService.getSong(itemId);
        }
        if (this.fileType == MediaFileType.IMAGE) {
            return ImageService.getImage(itemId);
        }
        if (this.fileType == MediaFileType.VIDEO) {
            return VideoService.getVideo(itemId);
        }
        return null;
    }

    private String getItemTitle(MediaItem item) {
        return item.getFileName();
    }
}

