/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.upnp.service.contentdirectory.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.serviio.library.entities.AccessGroup;
import org.serviio.library.metadata.MediaFileType;
import org.serviio.profile.Profile;
import org.serviio.upnp.service.contentdirectory.ObjectType;
import org.serviio.upnp.service.contentdirectory.SearchCriteria;
import org.serviio.upnp.service.contentdirectory.classes.ClassProperties;
import org.serviio.upnp.service.contentdirectory.classes.Container;
import org.serviio.upnp.service.contentdirectory.classes.DirectoryObjectBuilder;
import org.serviio.upnp.service.contentdirectory.classes.ObjectClassType;
import org.serviio.upnp.service.contentdirectory.command.AbstractCommand;
import org.serviio.upnp.service.contentdirectory.command.ObjectValuesBuilder;
import org.serviio.upnp.service.contentdirectory.definition.Definition;
import org.serviio.util.StringUtils;

public abstract class AbstractListInitialsCommand
extends AbstractCommand<Container> {
    public AbstractListInitialsCommand(String contextIdentifier, ObjectType objectType, SearchCriteria searchCriteria, ObjectClassType containerClassType, ObjectClassType itemClassType, Profile rendererProfile, AccessGroup accessGroup, MediaFileType fileType, String idPrefix, int startIndex, int count, boolean disablePresentationSettings) {
        super(contextIdentifier, objectType, searchCriteria, containerClassType, itemClassType, rendererProfile, accessGroup, fileType, idPrefix, startIndex, count, disablePresentationSettings);
    }

    protected abstract List<String> getListOfInitials(int var1, int var2);

    public static String getInitialId(String letter) {
        return String.valueOf(StringUtils.getUnicodeCode(letter));
    }

    @Override
    protected Set<ObjectClassType> getSupportedClasses() {
        return new HashSet<ObjectClassType>(Arrays.asList(ObjectClassType.CONTAINER, ObjectClassType.STORAGE_FOLDER));
    }

    @Override
    protected Set<ObjectType> getSupportedObjectTypes() {
        return ObjectType.getContainerTypes();
    }

    @Override
    protected List<Container> retrieveList() {
        ArrayList<Container> items = new ArrayList<Container>();
        List<String> letters = this.getListOfInitials(this.startIndex, this.count);
        for (String letter : letters) {
            String runtimeId = this.generateRuntimeObjectId(AbstractListInitialsCommand.getInitialId(letter));
            Map<ClassProperties, Object> values = ObjectValuesBuilder.instantiateValuesForContainer(letter, runtimeId, this.getDisplayedContainerId(this.objectId), this.objectType, this.searchCriteria, this.accessGroup, null, this.disablePresentationSettings);
            items.add((Container)DirectoryObjectBuilder.createInstance(this.containerClassType, values, null, null, this.disablePresentationSettings));
        }
        return items;
    }

    @Override
    protected Container retrieveSingleItem() {
        String title = StringUtils.getCharacterForCode(Integer.valueOf(this.getInternalObjectId()));
        Map<ClassProperties, Object> values = ObjectValuesBuilder.instantiateValuesForContainer(title, this.objectId, Definition.instance().getParentNodeId(this.objectId, this.disablePresentationSettings), this.objectType, this.searchCriteria, this.accessGroup, null, this.disablePresentationSettings);
        return (Container)DirectoryObjectBuilder.createInstance(this.containerClassType, values, null, null, this.disablePresentationSettings);
    }
}

