/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.upnp.service.contentdirectory.command;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.serviio.library.entities.AccessGroup;
import org.serviio.library.entities.Folder;
import org.serviio.library.local.service.FolderService;
import org.serviio.library.metadata.MediaFileType;
import org.serviio.profile.Profile;
import org.serviio.upnp.service.contentdirectory.ObjectType;
import org.serviio.upnp.service.contentdirectory.SearchCriteria;
import org.serviio.upnp.service.contentdirectory.classes.ObjectClassType;
import org.serviio.upnp.service.contentdirectory.command.AbstractEntityContainerCommand;

public abstract class AbstractListFlatFoldersByNameCommand
extends AbstractEntityContainerCommand<Folder> {
    public AbstractListFlatFoldersByNameCommand(String objectId, ObjectType objectType, SearchCriteria searchCriteria, ObjectClassType containerClassType, ObjectClassType itemClassType, Profile rendererProfile, AccessGroup accessGroup, MediaFileType fileType, String idPrefix, int startIndex, int count, boolean disablePresentationSettings) {
        super(objectId, objectType, searchCriteria, containerClassType, itemClassType, rendererProfile, accessGroup, fileType, idPrefix, startIndex, count, disablePresentationSettings);
    }

    @Override
    protected Set<ObjectClassType> getSupportedClasses() {
        return new HashSet<ObjectClassType>(Arrays.asList(ObjectClassType.CONTAINER, ObjectClassType.STORAGE_FOLDER));
    }

    @Override
    protected List<Folder> retrieveEntityList() {
        List<Folder> folders = FolderService.getListOfFoldersWithMedia(this.fileType, this.accessGroup, this.startIndex, this.count);
        return folders;
    }

    @Override
    protected Folder retrieveSingleEntity(Long entityId) {
        Folder folder = FolderService.getFolder(entityId);
        return folder;
    }

    @Override
    public int retrieveItemCount() {
        return FolderService.getNumberOfFoldersWithMedia(this.fileType, this.accessGroup);
    }

    @Override
    protected String getContainerTitle(Folder folder) {
        return folder.getName();
    }
}

