/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.upnp.service.contentdirectory.command;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.serviio.db.entities.PersistedEntity;
import org.serviio.library.entities.AccessGroup;
import org.serviio.library.entities.MediaItem;
import org.serviio.library.metadata.MediaFileType;
import org.serviio.profile.Profile;
import org.serviio.upnp.service.contentdirectory.ObjectNotFoundException;
import org.serviio.upnp.service.contentdirectory.ObjectType;
import org.serviio.upnp.service.contentdirectory.SearchCriteria;
import org.serviio.upnp.service.contentdirectory.classes.ClassProperties;
import org.serviio.upnp.service.contentdirectory.classes.DirectoryObjectBuilder;
import org.serviio.upnp.service.contentdirectory.classes.Item;
import org.serviio.upnp.service.contentdirectory.classes.ObjectClassType;
import org.serviio.upnp.service.contentdirectory.classes.Resource;
import org.serviio.upnp.service.contentdirectory.command.AbstractCommand;
import org.serviio.upnp.service.contentdirectory.command.ObjectValuesBuilder;
import org.serviio.upnp.service.contentdirectory.command.ResourceValuesBuilder;
import org.serviio.upnp.service.contentdirectory.definition.Definition;

public abstract class AbstractEntityItemCommand<E extends PersistedEntity>
extends AbstractCommand<Item> {
    public AbstractEntityItemCommand(String objectId, ObjectType objectType, SearchCriteria searchCriteria, ObjectClassType containerClassType, ObjectClassType itemClassType, Profile rendererProfile, AccessGroup accessGroup, MediaFileType fileType, String idPrefix, int startIndex, int count, boolean disablePresentationSettings) {
        super(objectId, objectType, searchCriteria, containerClassType, itemClassType, rendererProfile, accessGroup, fileType, idPrefix, startIndex, count, disablePresentationSettings);
    }

    @Override
    protected List<Item> retrieveList() {
        ArrayList<Item> items = new ArrayList<Item>();
        List<E> entities = this.retrieveEntityList();
        Long markedItemId = this.findMarkedItemId(false);
        for (PersistedEntity entity : entities) {
            boolean itemMarked = markedItemId != null && markedItemId.equals(entity.getId());
            Map<ClassProperties, Object> values = this.generateValuesForEntity(entity, this.generateRuntimeObjectId(entity.getId()), this.getDisplayedContainerId(this.objectId), this.getItemTitle(entity, itemMarked));
            List<Resource> res = this.generateResourcesForEntity(entity);
            items.add((Item)DirectoryObjectBuilder.createInstance(this.itemClassType, values, res, entity.getId(), this.disablePresentationSettings));
        }
        return items;
    }

    @Override
    protected Item retrieveSingleItem() {
        E entity = this.retrieveSingleEntity(new Long(this.getInternalObjectId()));
        if (entity != null) {
            Long markedItemId = this.findMarkedItemId(true);
            boolean itemMarked = markedItemId != null && markedItemId.equals(((PersistedEntity)entity).getId());
            Map<ClassProperties, Object> values = this.generateValuesForEntity(entity, this.objectId, Definition.instance().getParentNodeId(this.objectId, this.disablePresentationSettings), this.getItemTitle(entity, itemMarked));
            List<Resource> res = this.generateResourcesForEntity(entity);
            return (Item)DirectoryObjectBuilder.createInstance(this.itemClassType, values, res, ((PersistedEntity)entity).getId(), this.disablePresentationSettings);
        }
        throw new ObjectNotFoundException(String.format("Object with id %s not found in CDS", this.objectId));
    }

    @Override
    protected Set<ObjectType> getSupportedObjectTypes() {
        return ObjectType.getItemTypes();
    }

    protected Long findMarkedItemId(boolean forSingleItem) {
        return null;
    }

    protected abstract List<E> retrieveEntityList();

    protected abstract E retrieveSingleEntity(Long var1);

    protected abstract String getItemTitle(E var1, boolean var2);

    protected Map<ClassProperties, Object> generateValuesForEntity(E entity, String objectId, String parentId, String title) {
        return ObjectValuesBuilder.buildObjectValues(entity, objectId, parentId, this.objectType, this.searchCriteria, title, this.rendererProfile, this.accessGroup, this.fileType, this.disablePresentationSettings);
    }

    protected List<Resource> generateResourcesForEntity(E entity) {
        return ResourceValuesBuilder.buildResources((MediaItem)entity, this.rendererProfile);
    }
}

