/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.upnp.service.contentdirectory.command;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.serviio.db.entities.PersistedEntity;
import org.serviio.library.entities.AccessGroup;
import org.serviio.library.metadata.MediaFileType;
import org.serviio.profile.Profile;
import org.serviio.upnp.service.contentdirectory.ObjectNotFoundException;
import org.serviio.upnp.service.contentdirectory.ObjectType;
import org.serviio.upnp.service.contentdirectory.SearchCriteria;
import org.serviio.upnp.service.contentdirectory.classes.ClassProperties;
import org.serviio.upnp.service.contentdirectory.classes.Container;
import org.serviio.upnp.service.contentdirectory.classes.DirectoryObjectBuilder;
import org.serviio.upnp.service.contentdirectory.classes.ObjectClassType;
import org.serviio.upnp.service.contentdirectory.command.AbstractCommand;
import org.serviio.upnp.service.contentdirectory.command.CommandExecutionException;
import org.serviio.upnp.service.contentdirectory.command.ObjectValuesBuilder;
import org.serviio.upnp.service.contentdirectory.definition.Definition;

public abstract class AbstractEntityContainerCommand<E extends PersistedEntity>
extends AbstractCommand<Container> {
    public AbstractEntityContainerCommand(String objectId, ObjectType objectType, SearchCriteria searchCriteria, ObjectClassType containerClassType, ObjectClassType itemClassType, Profile rendererProfile, AccessGroup accessGroup, MediaFileType fileType, String idPrefix, int startIndex, int count, boolean disablePresentationSettings) {
        super(objectId, objectType, searchCriteria, containerClassType, itemClassType, rendererProfile, accessGroup, fileType, idPrefix, startIndex, count, disablePresentationSettings);
    }

    @Override
    protected List<Container> retrieveList() {
        ArrayList<Container> items = new ArrayList<Container>();
        List<E> entities = this.retrieveEntityList();
        for (PersistedEntity entity : entities) {
            String runtimeId = this.generateRuntimeObjectId(entity.getId());
            Map<ClassProperties, Object> values = this.generateValuesForEntity(entity, runtimeId, this.getDisplayedContainerId(this.objectId), this.getContainerTitle(entity));
            items.add((Container)DirectoryObjectBuilder.createInstance(this.containerClassType, values, this.getContainerResources(values, entity.getId(), this.rendererProfile), entity.getId(), this.disablePresentationSettings));
        }
        return items;
    }

    @Override
    public int retrieveItemCount() throws CommandExecutionException {
        return 0;
    }

    @Override
    protected Set<ObjectType> getSupportedObjectTypes() {
        return ObjectType.getContainerTypes();
    }

    @Override
    protected Container retrieveSingleItem() {
        E entity = this.retrieveSingleEntity(new Long(this.getInternalObjectId()));
        if (entity != null) {
            Map<ClassProperties, Object> values = this.generateValuesForEntity(entity, this.objectId, Definition.instance().getParentNodeId(this.objectId, this.disablePresentationSettings), this.getContainerTitle(entity));
            return (Container)DirectoryObjectBuilder.createInstance(this.containerClassType, values, this.getContainerResources(values, ((PersistedEntity)entity).getId(), this.rendererProfile), ((PersistedEntity)entity).getId(), this.disablePresentationSettings);
        }
        throw new ObjectNotFoundException(String.format("Object with id %s not found in CDS", this.objectId));
    }

    protected abstract List<E> retrieveEntityList();

    protected abstract E retrieveSingleEntity(Long var1);

    protected abstract String getContainerTitle(E var1);

    protected Map<ClassProperties, Object> generateValuesForEntity(E entity, String objectId, String parentId, String title) {
        return ObjectValuesBuilder.buildObjectValues(entity, objectId, parentId, this.objectType, this.searchCriteria, title, this.rendererProfile, this.accessGroup, this.fileType, this.disablePresentationSettings);
    }
}

