/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.upnp.service.contentdirectory.command;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.serviio.library.entities.AccessGroup;
import org.serviio.library.metadata.MediaFileType;
import org.serviio.profile.Profile;
import org.serviio.upnp.service.contentdirectory.BrowseItemsHolder;
import org.serviio.upnp.service.contentdirectory.ObjectNotFoundException;
import org.serviio.upnp.service.contentdirectory.ObjectType;
import org.serviio.upnp.service.contentdirectory.SearchCriteria;
import org.serviio.upnp.service.contentdirectory.classes.ClassProperties;
import org.serviio.upnp.service.contentdirectory.classes.DirectoryObject;
import org.serviio.upnp.service.contentdirectory.classes.ObjectClassType;
import org.serviio.upnp.service.contentdirectory.classes.Resource;
import org.serviio.upnp.service.contentdirectory.command.Command;
import org.serviio.upnp.service.contentdirectory.command.CommandExecutionException;
import org.serviio.upnp.service.contentdirectory.command.NonRecursiveIdGenerator;
import org.serviio.upnp.service.contentdirectory.command.ResourceValuesBuilder;
import org.serviio.upnp.service.contentdirectory.definition.Definition;

public abstract class AbstractCommand<T extends DirectoryObject>
implements Command<T> {
    protected String objectId;
    protected ObjectClassType containerClassType;
    protected SearchCriteria searchCriteria;
    protected ObjectClassType itemClassType;
    protected int startIndex;
    protected int count;
    protected String idPrefix;
    protected Profile rendererProfile;
    protected ObjectType objectType = ObjectType.ALL;
    protected AccessGroup accessGroup = AccessGroup.ANY;
    protected MediaFileType fileType;
    protected boolean disablePresentationSettings;

    public AbstractCommand(String objectId, ObjectType objectType, SearchCriteria searchCriteria, ObjectClassType containerClassType, ObjectClassType itemClassType, Profile rendererProfile, AccessGroup accessGroup, MediaFileType fileType, String idPrefix, int startIndex, int count, boolean disablePresentationSettings) {
        this.objectId = objectId;
        this.containerClassType = containerClassType;
        this.itemClassType = itemClassType;
        this.startIndex = startIndex;
        this.count = count;
        this.idPrefix = idPrefix;
        this.rendererProfile = rendererProfile;
        this.objectType = objectType;
        this.accessGroup = accessGroup;
        this.fileType = fileType;
        this.searchCriteria = searchCriteria;
        this.disablePresentationSettings = disablePresentationSettings;
    }

    @Override
    public BrowseItemsHolder<T> retrieveItemList() throws CommandExecutionException {
        try {
            this.validateSupportedClassTypes();
            ArrayList items = this.getSupportedObjectTypes().contains((Object)this.objectType) ? this.retrieveList() : new ArrayList();
            BrowseItemsHolder holder = new BrowseItemsHolder();
            holder.setItems(items);
            holder.setTotalMatched(this.getSupportedObjectTypes().contains((Object)this.objectType) ? this.retrieveItemCount() : 0);
            return holder;
        }
        catch (Exception e) {
            throw new CommandExecutionException(String.format("Cannot execute library command for list: %s", e.getMessage()), e);
        }
    }

    @Override
    public T retrieveItem() throws CommandExecutionException {
        try {
            this.validateSupportedClassTypes();
            return this.retrieveSingleItem();
        }
        catch (Exception e) {
            if (e instanceof ObjectNotFoundException) {
                throw (ObjectNotFoundException)e;
            }
            throw new CommandExecutionException(String.format("Cannot execute library command for single item: %s", e.getMessage()), e);
        }
    }

    protected abstract List<T> retrieveList();

    protected abstract T retrieveSingleItem();

    protected abstract Set<ObjectClassType> getSupportedClasses();

    protected abstract Set<ObjectType> getSupportedObjectTypes();

    protected String generateRuntimeObjectId(Number entityId) {
        return this.generateRuntimeObjectId(entityId.toString());
    }

    protected String generateRuntimeObjectId(String objectIdentifier) {
        return NonRecursiveIdGenerator.generateId(this.objectId, this.idPrefix, objectIdentifier);
    }

    protected String getInternalObjectId() {
        if (this.objectId.indexOf("^") > 1) {
            return this.objectId.substring(this.objectId.lastIndexOf("_") + 1);
        }
        return "0";
    }

    protected List<Resource> getContainerResources(Map<ClassProperties, Object> entityValues, Long entityId, Profile rendererProfile) {
        Resource incompleteThumbnailResource = (Resource)entityValues.get((Object)ClassProperties.ICON);
        if (incompleteThumbnailResource != null) {
            Resource thumbnailResource = ResourceValuesBuilder.generateThumbnailResource(entityId, incompleteThumbnailResource.getResourceId(), rendererProfile, true);
            return Collections.singletonList(thumbnailResource);
        }
        return Collections.emptyList();
    }

    protected String getInternalObjectId(String objectId) {
        if (objectId.indexOf("^") > 1) {
            return objectId.substring(objectId.lastIndexOf("_") + 1);
        }
        return "0";
    }

    protected String getDisplayedContainerId(String objectId) {
        if (Definition.instance().isOnlyShowContentsOfContainer(objectId, this.disablePresentationSettings)) {
            return Definition.instance().getParentNodeId(objectId, this.disablePresentationSettings);
        }
        return objectId;
    }

    private void validateSupportedClassTypes() throws CommandExecutionException {
        if (this.containerClassType != null && !this.getSupportedClasses().contains((Object)this.containerClassType)) {
            throw new CommandExecutionException(String.format("Class %s is not supported by the Command %s", this.containerClassType.toString(), this.getClass().getName()));
        }
        if (this.itemClassType != null && !this.getSupportedClasses().contains((Object)this.itemClassType)) {
            throw new CommandExecutionException(String.format("Class %s is not supported by the Command %s", this.itemClassType.toString(), this.getClass().getName()));
        }
    }

    public String getContextIdentifier() {
        return this.objectId;
    }

    public ObjectClassType getContainerClassType() {
        return this.containerClassType;
    }

    public ObjectClassType getItemClassType() {
        return this.itemClassType;
    }
}

