/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.upnp.service.contentdirectory.classes;

import java.util.List;
import java.util.Map;
import org.serviio.library.local.ContentType;
import org.serviio.library.local.metadata.MPAARating;
import org.serviio.upnp.service.contentdirectory.classes.AudioItem;
import org.serviio.upnp.service.contentdirectory.classes.ClassProperties;
import org.serviio.upnp.service.contentdirectory.classes.Container;
import org.serviio.upnp.service.contentdirectory.classes.DirectoryObject;
import org.serviio.upnp.service.contentdirectory.classes.Genre;
import org.serviio.upnp.service.contentdirectory.classes.ImageItem;
import org.serviio.upnp.service.contentdirectory.classes.Item;
import org.serviio.upnp.service.contentdirectory.classes.Movie;
import org.serviio.upnp.service.contentdirectory.classes.MusicAlbum;
import org.serviio.upnp.service.contentdirectory.classes.MusicArtist;
import org.serviio.upnp.service.contentdirectory.classes.MusicGenre;
import org.serviio.upnp.service.contentdirectory.classes.MusicTrack;
import org.serviio.upnp.service.contentdirectory.classes.ObjectClassType;
import org.serviio.upnp.service.contentdirectory.classes.Person;
import org.serviio.upnp.service.contentdirectory.classes.Photo;
import org.serviio.upnp.service.contentdirectory.classes.PlaylistContainer;
import org.serviio.upnp.service.contentdirectory.classes.Resource;
import org.serviio.upnp.service.contentdirectory.classes.StorageFolder;
import org.serviio.upnp.service.contentdirectory.classes.VideoItem;
import org.serviio.upnp.service.contentdirectory.definition.Definition;

public class DirectoryObjectBuilder {
    public static DirectoryObject createInstance(ObjectClassType type, Map<ClassProperties, Object> values, List<Resource> resources, Long entityId, boolean disablePresentationSettings) {
        if (type == ObjectClassType.CONTAINER) {
            Container container = new Container((String)values.get((Object)ClassProperties.ID), (String)values.get((Object)ClassProperties.TITLE));
            DirectoryObjectBuilder.setupContainer(container, values, resources, entityId, disablePresentationSettings);
            return container;
        }
        if (type == ObjectClassType.AUDIO_ITEM) {
            AudioItem item = new AudioItem((String)values.get((Object)ClassProperties.ID), (String)values.get((Object)ClassProperties.TITLE));
            DirectoryObjectBuilder.setupAudioItem(item, values, resources, entityId);
            return item;
        }
        if (type == ObjectClassType.MUSIC_TRACK) {
            MusicTrack item = new MusicTrack((String)values.get((Object)ClassProperties.ID), (String)values.get((Object)ClassProperties.TITLE));
            DirectoryObjectBuilder.setupMusicTrack(item, values, resources, entityId);
            return item;
        }
        if (type == ObjectClassType.GENRE) {
            Genre container = new Genre((String)values.get((Object)ClassProperties.ID), (String)values.get((Object)ClassProperties.TITLE));
            DirectoryObjectBuilder.setupGenre(container, values, resources, entityId, disablePresentationSettings);
            return container;
        }
        if (type == ObjectClassType.MUSIC_GENRE) {
            MusicGenre container = new MusicGenre((String)values.get((Object)ClassProperties.ID), (String)values.get((Object)ClassProperties.TITLE));
            DirectoryObjectBuilder.setupGenre(container, values, resources, entityId, disablePresentationSettings);
            return container;
        }
        if (type == ObjectClassType.PERSON) {
            Person container = new Person((String)values.get((Object)ClassProperties.ID), (String)values.get((Object)ClassProperties.TITLE));
            DirectoryObjectBuilder.setupPerson(container, values, resources, entityId, disablePresentationSettings);
            return container;
        }
        if (type == ObjectClassType.MUSIC_ARTIST) {
            MusicArtist container = new MusicArtist((String)values.get((Object)ClassProperties.ID), (String)values.get((Object)ClassProperties.TITLE));
            DirectoryObjectBuilder.setupMusicArtist(container, values, resources, entityId, disablePresentationSettings);
            return container;
        }
        if (type == ObjectClassType.IMAGE_ITEM) {
            ImageItem item = new ImageItem((String)values.get((Object)ClassProperties.ID), (String)values.get((Object)ClassProperties.TITLE));
            DirectoryObjectBuilder.setupImageItem(item, values, resources, entityId);
            return item;
        }
        if (type == ObjectClassType.PHOTO) {
            Photo item = new Photo((String)values.get((Object)ClassProperties.ID), (String)values.get((Object)ClassProperties.TITLE));
            DirectoryObjectBuilder.setupPhoto(item, values, resources, entityId);
            return item;
        }
        if (type == ObjectClassType.VIDEO_ITEM) {
            VideoItem item = new VideoItem((String)values.get((Object)ClassProperties.ID), (String)values.get((Object)ClassProperties.TITLE));
            DirectoryObjectBuilder.setupVideoItem(item, values, resources, entityId);
            return item;
        }
        if (type == ObjectClassType.MOVIE) {
            Movie item = new Movie((String)values.get((Object)ClassProperties.ID), (String)values.get((Object)ClassProperties.TITLE));
            DirectoryObjectBuilder.setupMovie(item, values, resources, entityId);
            return item;
        }
        if (type == ObjectClassType.STORAGE_FOLDER) {
            StorageFolder container = new StorageFolder((String)values.get((Object)ClassProperties.ID), (String)values.get((Object)ClassProperties.TITLE));
            DirectoryObjectBuilder.setupStorageFolder(container, values, resources, entityId, disablePresentationSettings);
            return container;
        }
        if (type == ObjectClassType.MUSIC_ALBUM) {
            MusicAlbum container = new MusicAlbum((String)values.get((Object)ClassProperties.ID), (String)values.get((Object)ClassProperties.TITLE));
            DirectoryObjectBuilder.setupMusicAlbum(container, values, resources, entityId, disablePresentationSettings);
            return container;
        }
        if (type == ObjectClassType.PLAYLIST_CONTAINER) {
            PlaylistContainer container = new PlaylistContainer((String)values.get((Object)ClassProperties.ID), (String)values.get((Object)ClassProperties.TITLE));
            DirectoryObjectBuilder.setupPlaylistContainer(container, values, resources, entityId, disablePresentationSettings);
            return container;
        }
        return null;
    }

    private static void setupObject(DirectoryObject object, Map<ClassProperties, Object> values, List<Resource> resources, Long entityId) {
        org.serviio.library.entities.Person creator = (org.serviio.library.entities.Person)values.get((Object)ClassProperties.CREATOR);
        if (creator != null) {
            object.setCreator(creator.getName());
        }
        object.setParentID((String)values.get((Object)ClassProperties.PARENT_ID));
        if (resources != null) {
            object.setResources(resources);
        }
        object.setEntityId(entityId);
        object.setIcon((Resource)values.get((Object)ClassProperties.ICON));
        object.setAlbumArtURIResource((Resource)values.get((Object)ClassProperties.ALBUM_ART_URI));
    }

    private static void setupContainer(Container container, Map<ClassProperties, Object> values, List<Resource> resources, Long entityId, boolean disablePresentationSettings) {
        DirectoryObjectBuilder.setupObject(container, values, resources, entityId);
        container.setChildCount((Integer)values.get((Object)ClassProperties.CHILD_COUNT));
        container.setSearchable((Boolean)values.get((Object)ClassProperties.SEARCHABLE));
        String mediaClass = DirectoryObjectBuilder.getMediaClass(container, disablePresentationSettings);
        container.setMediaClass(mediaClass);
    }

    private static void setupItem(Item item, Map<ClassProperties, Object> values, List<Resource> resources, Long entityId) {
        DirectoryObjectBuilder.setupObject(item, values, resources, entityId);
        item.setRefID((String)values.get((Object)ClassProperties.REF_ID));
        item.setDcmInfo((String)values.get((Object)ClassProperties.DCM_INFO));
    }

    private static void setupAudioItem(AudioItem item, Map<ClassProperties, Object> values, List<Resource> resources, Long entityId) {
        DirectoryObjectBuilder.setupItem(item, values, resources, entityId);
        item.setDescription((String)values.get((Object)ClassProperties.DESCRIPTION));
        org.serviio.library.entities.Genre genre = (org.serviio.library.entities.Genre)values.get((Object)ClassProperties.GENRE);
        if (genre != null) {
            item.setGenre(genre.getName());
        }
        item.setLanguage((String)values.get((Object)ClassProperties.LANGUAGE));
        item.setLongDescription((String)values.get((Object)ClassProperties.LONG_DESCRIPTION));
        item.setPublisher((String)values.get((Object)ClassProperties.PUBLISHER));
        item.setRights((String)values.get((Object)ClassProperties.RIGHTS));
        item.setLive((Boolean)values.get((Object)ClassProperties.LIVE));
    }

    private static void setupMusicTrack(MusicTrack item, Map<ClassProperties, Object> values, List<Resource> resources, Long entityId) {
        org.serviio.library.entities.Person artist;
        DirectoryObjectBuilder.setupAudioItem(item, values, resources, entityId);
        org.serviio.library.entities.MusicAlbum album = (org.serviio.library.entities.MusicAlbum)values.get((Object)ClassProperties.ALBUM);
        if (album != null) {
            item.setAlbum(album.getTitle());
        }
        if ((artist = (org.serviio.library.entities.Person)values.get((Object)ClassProperties.ARTIST)) != null) {
            item.setArtist(new String[]{artist.getName()});
        }
        item.setDate((String)values.get((Object)ClassProperties.DATE));
        item.setOriginalTrackNumber((Integer)values.get((Object)ClassProperties.ORIGINAL_TRACK_NUMBER));
    }

    private static void setupGenre(Genre item, Map<ClassProperties, Object> values, List<Resource> resources, Long entityId, boolean disablePresentationSettings) {
        DirectoryObjectBuilder.setupContainer(item, values, resources, entityId, disablePresentationSettings);
    }

    private static void setupPerson(Person item, Map<ClassProperties, Object> values, List<Resource> resources, Long entityId, boolean disablePresentationSettings) {
        DirectoryObjectBuilder.setupContainer(item, values, resources, entityId, disablePresentationSettings);
    }

    private static void setupMusicArtist(MusicArtist item, Map<ClassProperties, Object> values, List<Resource> resources, Long entityId, boolean disablePresentationSettings) {
        DirectoryObjectBuilder.setupPerson(item, values, resources, entityId, disablePresentationSettings);
    }

    private static void setupImageItem(ImageItem item, Map<ClassProperties, Object> values, List<Resource> resources, Long entityId) {
        DirectoryObjectBuilder.setupItem(item, values, resources, entityId);
        item.setDescription((String)values.get((Object)ClassProperties.DESCRIPTION));
        item.setLongDescription((String)values.get((Object)ClassProperties.LONG_DESCRIPTION));
        item.setRights((String)values.get((Object)ClassProperties.RIGHTS));
        item.setPublisher((String[])values.get((Object)ClassProperties.PUBLISHER));
        item.setDate((String)values.get((Object)ClassProperties.DATE));
    }

    private static void setupPhoto(Photo item, Map<ClassProperties, Object> values, List<Resource> resources, Long entityId) {
        DirectoryObjectBuilder.setupImageItem(item, values, resources, entityId);
        item.setAlbum((String)values.get((Object)ClassProperties.ALBUM));
    }

    private static void setupVideoItem(VideoItem item, Map<ClassProperties, Object> values, List<Resource> resources, Long entityId) {
        DirectoryObjectBuilder.setupItem(item, values, resources, entityId);
        org.serviio.library.entities.Genre genre = (org.serviio.library.entities.Genre)values.get((Object)ClassProperties.GENRE);
        if (genre != null) {
            item.setGenre(genre.getName());
        }
        item.setDescription((String)values.get((Object)ClassProperties.DESCRIPTION));
        item.setDate((String)values.get((Object)ClassProperties.DATE));
        item.setLongDescription((String)values.get((Object)ClassProperties.LONG_DESCRIPTION));
        item.setRating(((MPAARating)((Object)values.get((Object)ClassProperties.RATING))).toString());
        item.setLanguage((String)values.get((Object)ClassProperties.LANGUAGE));
        item.setSubtitlesUrlResource((Resource)values.get((Object)ClassProperties.SUBTITLES_URL));
        item.setPublishers(DirectoryObjectBuilder.getPersonsNames((List)values.get((Object)ClassProperties.PUBLISHER)));
        item.setActors(DirectoryObjectBuilder.getPersonsNames((List)values.get((Object)ClassProperties.ACTOR)));
        item.setDirectors(DirectoryObjectBuilder.getPersonsNames((List)values.get((Object)ClassProperties.DIRECTOR)));
        item.setProducers(DirectoryObjectBuilder.getPersonsNames((List)values.get((Object)ClassProperties.PRODUCER)));
        item.setLive((Boolean)values.get((Object)ClassProperties.LIVE));
        item.setContentType((ContentType)((Object)values.get((Object)ClassProperties.CONTENT_TYPE)));
        item.setOnlineIdentifiers((Map)values.get((Object)ClassProperties.ONLINE_DB_IDENTIFIERS));
    }

    private static void setupMovie(Movie item, Map<ClassProperties, Object> values, List<Resource> resources, Long entityId) {
        DirectoryObjectBuilder.setupVideoItem(item, values, resources, entityId);
    }

    private static void setupStorageFolder(StorageFolder container, Map<ClassProperties, Object> values, List<Resource> resources, Long entityId, boolean disablePresentationSettings) {
        DirectoryObjectBuilder.setupContainer(container, values, resources, entityId, disablePresentationSettings);
    }

    private static void setupMusicAlbum(MusicAlbum container, Map<ClassProperties, Object> values, List<Resource> resources, Long entityId, boolean disablePresentationSettings) {
        DirectoryObjectBuilder.setupContainer(container, values, resources, entityId, disablePresentationSettings);
        container.setArtist((String)values.get((Object)ClassProperties.ARTIST));
    }

    private static void setupPlaylistContainer(PlaylistContainer container, Map<ClassProperties, Object> values, List<Resource> resources, Long entityId, boolean disablePresentationSettings) {
        DirectoryObjectBuilder.setupContainer(container, values, resources, entityId, disablePresentationSettings);
    }

    private static String[] getPersonsNames(List<org.serviio.library.entities.Person> persons) {
        if (persons != null && persons.size() > 0) {
            String[] names = new String[persons.size()];
            for (int i = 0; i < persons.size(); ++i) {
                org.serviio.library.entities.Person person = persons.get(i);
                names[i] = person.getName();
            }
            return names;
        }
        return null;
    }

    private static String getMediaClass(Container container, boolean disablePresentationSettings) {
        String mediaClass = DirectoryObjectBuilder.getContainerMediaClass(container.getId());
        if (mediaClass == null) {
            String parentId = container.getId();
            while (mediaClass == null && !parentId.equals("-1")) {
                parentId = Definition.instance().getParentNodeId(parentId, disablePresentationSettings);
                mediaClass = DirectoryObjectBuilder.getContainerMediaClass(parentId);
            }
        }
        return mediaClass;
    }

    private static String getContainerMediaClass(String containerId) {
        if (containerId.equals("-1") || containerId.equals("0")) {
            return null;
        }
        if (containerId.equals("A")) {
            return "M";
        }
        if (containerId.equals("I")) {
            return "P";
        }
        if (containerId.equals("V")) {
            return "V";
        }
        return null;
    }
}

