/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.upnp.service.contentdirectory;

import org.serviio.dlna.MediaFormatProfile;
import org.serviio.upnp.service.contentdirectory.GenericDLNAMessageBuilder;
import org.serviio.upnp.service.contentdirectory.classes.ClassProperties;
import org.serviio.upnp.service.contentdirectory.classes.DirectoryObject;
import org.serviio.upnp.service.contentdirectory.classes.Resource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SamsungDLNAMessageBuilder
extends GenericDLNAMessageBuilder {
    public SamsungDLNAMessageBuilder(String filter) {
        super(filter);
    }

    @Override
    protected Node storeRootNode(Document document) {
        Element node = (Element)super.storeRootNode(document);
        node.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:sec", "http://www.sec.co.kr/");
        return node;
    }

    @Override
    protected void storeItemFields(Node itemNode, DirectoryObject object) {
        super.storeItemFields(itemNode, object);
        Node subtitlesNode = this.storeNode(itemNode, object, ClassProperties.SUBTITLES_URL, "sec:CaptionInfoEx", false);
        this.storeStaticAttribute(subtitlesNode, "sec:type", "http://www.sec.co.kr/", "srt");
        this.storeNode(itemNode, object, ClassProperties.DCM_INFO, false);
        if (this.isResourceRequired()) {
            boolean smResourceExists = false;
            Resource newThumbnailResource = null;
            for (Resource resource : object.getResources()) {
                if (resource.getResourceType() == Resource.ResourceType.COVER_IMAGE) {
                    newThumbnailResource = new Resource(resource.getResourceType(), resource.getResourceId(), MediaFormatProfile.JPEG_SM, resource.getProtocolInfoIndex(), resource.getQuality(), resource.isTranscoded());
                    newThumbnailResource.setProtocolInfo(resource.getProtocolInfo().replaceFirst(MediaFormatProfile.JPEG_TN.toString(), MediaFormatProfile.JPEG_SM.toString()));
                    newThumbnailResource.setResolution(resource.getResolution());
                    continue;
                }
                if (resource.getVersion() != MediaFormatProfile.JPEG_SM) continue;
                smResourceExists = true;
            }
            if (!smResourceExists && newThumbnailResource != null) {
                this.storeResource(itemNode, newThumbnailResource);
            }
        }
    }
}

