/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.upnp.service.contentdirectory;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.serviio.library.metadata.MediaFileType;
import org.serviio.upnp.service.contentdirectory.ProtocolAdditionalInfo;

public class ProtocolInfo {
    private String protocol = "http-get";
    private String context = "*";
    private String mimeType;
    private List<? extends ProtocolAdditionalInfo> additionalInfos;

    public ProtocolInfo(String mimeType, List<? extends ProtocolAdditionalInfo> additionalInfos) {
        this.mimeType = mimeType;
        this.additionalInfos = additionalInfos;
    }

    public Set<String> getMediaProtocolInfo(boolean transcoded, boolean live, MediaFileType fileType, boolean durationAvailable) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (ProtocolAdditionalInfo protocolAdditionalInfo : this.additionalInfos) {
            String additionalInfoField = protocolAdditionalInfo.buildMediaProtocolInfo(transcoded, live, fileType, durationAvailable);
            result.add(String.format("%s:%s:%s:%s", this.protocol, this.context, this.mimeType, additionalInfoField));
        }
        return result;
    }

    public Set<String> getProfileProtocolInfo(MediaFileType fileType) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (ProtocolAdditionalInfo protocolAdditionalInfo : this.additionalInfos) {
            String additionalInfoField = protocolAdditionalInfo.buildProfileProtocolInfo(fileType);
            result.add(String.format("%s:%s:%s:%s", this.protocol, this.context, this.mimeType, additionalInfoField));
        }
        return result;
    }

    public List<? extends ProtocolAdditionalInfo> getAdditionalInfos() {
        return this.additionalInfos;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public void setAdditionalInfos(List<? extends ProtocolAdditionalInfo> additionalInfos) {
        this.additionalInfos = additionalInfos;
    }
}

