/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.upnp.service.contentdirectory;

import javax.xml.xpath.XPathExpressionException;
import org.serviio.upnp.service.contentdirectory.GenericDLNAMessageBuilder;
import org.serviio.upnp.service.contentdirectory.SamsungDLNAMessageBuilder;
import org.serviio.upnp.service.contentdirectory.classes.ClassProperties;
import org.serviio.upnp.service.contentdirectory.classes.DirectoryObject;
import org.serviio.upnp.service.contentdirectory.classes.Resource;
import org.serviio.util.XPathUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PacketVideoDLNAMessageBuilder
extends GenericDLNAMessageBuilder {
    private static final Logger log = LoggerFactory.getLogger(SamsungDLNAMessageBuilder.class);
    private static final String PV_NAMESPACE_URL = "http://www.pv.com/pvns/";

    public PacketVideoDLNAMessageBuilder(String filter) {
        super(filter);
    }

    @Override
    protected Node storeRootNode(Document document) {
        Element node = (Element)super.storeRootNode(document);
        node.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:pv", PV_NAMESPACE_URL);
        return node;
    }

    @Override
    protected void storeItemFields(Node itemNode, DirectoryObject object) {
        super.storeItemFields(itemNode, object);
        if (this.isResourceRequired() && this.includedFieldsContainsAnyPropertyFilterName(ClassProperties.SUBTITLES_URL)) {
            try {
                int i = 0;
                for (Resource resource : object.getResources()) {
                    Node resourceNode;
                    boolean subtitleAdded;
                    if (resource.getResourceType() == Resource.ResourceType.MEDIA_ITEM && (subtitleAdded = this.storeAttribute(resourceNode = XPathUtil.getNode(itemNode, "res[" + (i + 1) + "]"), object, ClassProperties.SUBTITLES_URL, "pv:subtitleFileUri", false))) {
                        this.storeStaticAttribute(resourceNode, "pv:subtitleFileType", PV_NAMESPACE_URL, "SRT");
                    }
                    ++i;
                }
            }
            catch (XPathExpressionException e) {
                log.warn("Cannot resolve resource elements for injection of subtitles information: " + e.getMessage());
            }
        }
    }
}

