/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.upnp.service.contentdirectory;

import org.apache.jcs.access.exception.CacheException;
import org.serviio.cache.AbstractCacheDecorator;
import org.serviio.library.entities.AccessGroup;
import org.serviio.profile.Profile;
import org.serviio.upnp.service.contentdirectory.BrowseItemsHolder;
import org.serviio.upnp.service.contentdirectory.CDSCacheDecorator;
import org.serviio.upnp.service.contentdirectory.ObjectType;
import org.serviio.upnp.service.contentdirectory.classes.DirectoryObject;

public class LocalContentCacheDecorator
extends AbstractCacheDecorator
implements CDSCacheDecorator {
    public LocalContentCacheDecorator(String regionName) {
        super(regionName);
    }

    @Override
    public BrowseItemsHolder<DirectoryObject> retrieve(String objectID, ObjectType objectType, String browseFlag, String filter, int startingIndex, int requestedCount, String sortCriteria, Profile rendererProfile, AccessGroup accessGroup, boolean disablePresentationSettings) {
        BrowseItemsHolder object = (BrowseItemsHolder)this.cache.get((Object)this.generateKey(objectID, objectType, browseFlag, filter, startingIndex, requestedCount, sortCriteria, rendererProfile, accessGroup, disablePresentationSettings));
        if (object != null) {
            this.log.debug(String.format("Found entry in the cache (%s), returning it", this.regionName));
        }
        return object;
    }

    @Override
    public void store(BrowseItemsHolder<DirectoryObject> object, String objectID, ObjectType objectType, String browseFlag, String filter, int startingIndex, int requestedCount, String sortCriteria, Profile rendererProfile, AccessGroup accessGroup, boolean disablePresentationSettings) {
        try {
            this.cache.put((Object)this.generateKey(objectID, objectType, browseFlag, filter, startingIndex, requestedCount, sortCriteria, rendererProfile, accessGroup, disablePresentationSettings), object);
            this.log.debug(String.format("Stored entry in the cache (%s), returning it", this.regionName));
        }
        catch (CacheException e) {
            this.log.warn(String.format("Could not store object to local cache(%s): %s", this.regionName, e.getMessage()));
        }
    }

    private String generateKey(String containerID, ObjectType objectType, String browseFlag, String filter, int startingIndex, int requestedCount, String sortCriteria, Profile rendererProfile, AccessGroup accessGroup, boolean disablePresentationSettings) {
        StringBuffer sb = new StringBuffer();
        sb.append(containerID).append(":").append(browseFlag).append(":").append(objectType.toString()).append(":").append(filter).append(":").append(startingIndex).append(":").append(requestedCount).append(":").append(sortCriteria).append(":").append(rendererProfile.getId()).append(":").append(accessGroup.getId() != null ? accessGroup.getId() : "any").append(":").append(disablePresentationSettings);
        return sb.toString();
    }
}

