/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.upnp.service.contentdirectory;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.serviio.delivery.HostInfo;
import org.serviio.upnp.service.contentdirectory.ContentDirectoryMessageBuilder;
import org.serviio.upnp.service.contentdirectory.classes.ClassProperties;
import org.serviio.upnp.service.contentdirectory.classes.Container;
import org.serviio.upnp.service.contentdirectory.classes.DirectoryObject;
import org.serviio.upnp.service.contentdirectory.classes.ObjectClassType;
import org.serviio.upnp.service.contentdirectory.classes.Resource;
import org.serviio.util.StringUtils;
import org.serviio.util.XmlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class GenericDLNAMessageBuilder
implements ContentDirectoryMessageBuilder {
    private static final Logger log = LoggerFactory.getLogger(GenericDLNAMessageBuilder.class);
    private static DocumentBuilder xmlBuilder;
    private Set<String> includedFields;

    public GenericDLNAMessageBuilder(String filter) {
        if (!filter.equals("*")) {
            String[] fields;
            this.includedFields = new HashSet<String>();
            for (String field : fields = filter.split(",")) {
                this.includedFields.add(StringUtils.localeSafeToLowercase(field.trim()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Document buildXML(List<DirectoryObject> objects) {
        Document xml = null;
        DocumentBuilder documentBuilder = xmlBuilder;
        synchronized (documentBuilder) {
            xml = xmlBuilder.newDocument();
        }
        Node rootNode = this.storeRootNode(xml);
        for (DirectoryObject object : objects) {
            this.storeObjectNode(object, rootNode);
        }
        return xml;
    }

    protected HostInfo getHostInfo() {
        return HostInfo.defaultHostInfo();
    }

    protected Node storeRootNode(Document document) {
        Element rootNode = document.createElementNS("urn:schemas-upnp-org:metadata-1-0/DIDL-Lite/", "DIDL-Lite");
        rootNode.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:dc", "http://purl.org/dc/elements/1.1/");
        rootNode.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:upnp", "urn:schemas-upnp-org:metadata-1-0/upnp/");
        rootNode.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:dlna", "urn:schemas-dlna-org:metadata-1-0/");
        document.appendChild(rootNode);
        return rootNode;
    }

    protected void storeObjectNode(DirectoryObject object, Node rootNode) {
        Element objectNode = null;
        if (object instanceof Container) {
            objectNode = this.getDocument(rootNode).createElement("container");
            this.storeContainerFields(objectNode, object);
        } else {
            objectNode = this.getDocument(rootNode).createElement("item");
            this.storeItemFields(objectNode, object);
        }
        rootNode.appendChild(objectNode);
    }

    protected void storeContainerFields(Node containerNode, DirectoryObject object) {
        this.storeAttribute(containerNode, object, ClassProperties.ID, true);
        this.storeAttribute(containerNode, object, ClassProperties.PARENT_ID, true);
        this.storeAttribute(containerNode, object, ClassProperties.RESTRICTED, true);
        this.storeAttribute(containerNode, object, ClassProperties.CHILD_COUNT, false);
        this.storeAttribute(containerNode, object, ClassProperties.SEARCHABLE, false);
        this.storeNode(containerNode, object, ClassProperties.ICON, false);
        this.storeNode(containerNode, object, ClassProperties.TITLE, true);
        this.storeNode(containerNode, object, ClassProperties.OBJECT_CLASS, true);
        this.storeNode(containerNode, object, ClassProperties.ARTIST, false);
        Node albumArtNode = this.storeNode(containerNode, object, ClassProperties.ALBUM_ART_URI, false);
        this.storeStaticAttribute(albumArtNode, "dlna:profileID", "urn:schemas-dlna-org:metadata-1-0/", "JPEG_TN");
        this.storeResources(containerNode, object);
    }

    protected void storeItemFields(Node itemNode, DirectoryObject object) {
        this.storeAttribute(itemNode, object, ClassProperties.ID, true);
        this.storeAttribute(itemNode, object, ClassProperties.PARENT_ID, true);
        this.storeAttribute(itemNode, object, ClassProperties.RESTRICTED, true);
        this.storeAttribute(itemNode, object, ClassProperties.REF_ID, false);
        this.storeNode(itemNode, object, ClassProperties.TITLE, true);
        this.storeNode(itemNode, object, ClassProperties.OBJECT_CLASS, true);
        this.storeNode(itemNode, object, ClassProperties.CREATOR, false);
        Node albumArtNode = this.storeNode(itemNode, object, ClassProperties.ALBUM_ART_URI, false);
        this.storeStaticAttribute(albumArtNode, "dlna:profileID", "urn:schemas-dlna-org:metadata-1-0/", "JPEG_TN");
        this.storeNode(itemNode, object, ClassProperties.ORIGINAL_TRACK_NUMBER, false);
        this.storeNode(itemNode, object, ClassProperties.ICON, false);
        this.storeNode(itemNode, object, ClassProperties.ALBUM, false);
        this.storeNode(itemNode, object, ClassProperties.DATE, false);
        this.storeNode(itemNode, object, ClassProperties.GENRE, false);
        this.storeNode(itemNode, object, ClassProperties.DESCRIPTION, false);
        this.storeNode(itemNode, object, ClassProperties.RIGHTS, false);
        this.storeNode(itemNode, object, ClassProperties.PUBLISHER, false);
        this.storeNode(itemNode, object, ClassProperties.ARTIST, false);
        this.storeNode(itemNode, object, ClassProperties.RATING, false);
        this.storeNode(itemNode, object, ClassProperties.ACTOR, false);
        this.storeNode(itemNode, object, ClassProperties.DIRECTOR, false);
        this.storeNode(itemNode, object, ClassProperties.PRODUCER, false);
        this.storeResources(itemNode, object);
    }

    private void storeResources(Node itemNode, DirectoryObject object) {
        if (this.isResourceRequired()) {
            for (Resource resource : object.getResources()) {
                this.storeResource(itemNode, resource);
            }
        }
    }

    protected void storeResource(Node itemNode, Resource resource) {
        Node resourceNode = this.storeNode(itemNode, resource, ClassProperties.RESOURCE_URL, true);
        this.storeAttribute(resourceNode, resource, ClassProperties.RESOURCE_DURATION, false);
        this.storeAttribute(resourceNode, resource, ClassProperties.RESOURCE_PROTOCOLINFO, true);
        this.storeAttribute(resourceNode, resource, ClassProperties.RESOURCE_SIZE, false);
        this.storeAttribute(resourceNode, resource, ClassProperties.RESOURCE_BITRATE, false);
        this.storeAttribute(resourceNode, resource, ClassProperties.RESOURCE_CHANNELS, false);
        this.storeAttribute(resourceNode, resource, ClassProperties.RESOURCE_SAMPLE_FREQUENCY, false);
        this.storeAttribute(resourceNode, resource, ClassProperties.RESOURCE_RESOLUTION, false);
        this.storeAttribute(resourceNode, resource, ClassProperties.RESOURCE_COLOR_DEPTH, false);
    }

    protected Node storeNode(Node parentNode, Object object, ClassProperties classAttribute, String propertyXMLName, boolean mandatory) {
        if (parentNode != null) {
            if (mandatory || this.fieldIncluded(classAttribute)) {
                Object value = this.getObjectValue(classAttribute.getAttributeName(), object);
                if (value != null) {
                    Document document = this.getDocument(parentNode);
                    if (value.getClass().isArray()) {
                        for (Object arrayItem : (Object[])value) {
                            Element node = document.createElement(propertyXMLName);
                            node.setTextContent(this.castObjectValue(arrayItem));
                            parentNode.appendChild(node);
                        }
                        return null;
                    }
                    Element node = document.createElement(propertyXMLName);
                    node.setTextContent(this.castObjectValue(value));
                    parentNode.appendChild(node);
                    return node;
                }
                if (mandatory) {
                    throw new RuntimeException(String.format("Missing required class attribute '%s'", new Object[]{classAttribute}));
                }
                return null;
            }
            return null;
        }
        return null;
    }

    protected Node storeNode(Node parentNode, Object object, ClassProperties classAttribute, boolean mandatory) {
        return this.storeNode(parentNode, object, classAttribute, classAttribute.getFirstPropertyXMLName(), mandatory);
    }

    protected boolean storeAttribute(Node parentNode, Object object, ClassProperties classAttribute, String propertyXMLName, boolean mandatory) {
        if (parentNode != null && (mandatory || this.fieldIncluded(classAttribute))) {
            Object value = this.getObjectValue(classAttribute.getAttributeName(), object);
            if (value != null) {
                Document document = this.getDocument(parentNode);
                Attr attribute = document.createAttribute(propertyXMLName);
                attribute.setTextContent(this.castObjectValue(value));
                parentNode.getAttributes().setNamedItem(attribute);
                return true;
            }
            if (mandatory) {
                throw new RuntimeException(String.format("Missing required class attribute '%s' on object: %s", new Object[]{classAttribute, object.toString()}));
            }
        }
        return false;
    }

    protected void storeAttribute(Node parentNode, Object object, ClassProperties classAttribute, boolean mandatory) {
        this.storeAttribute(parentNode, object, classAttribute, classAttribute.getFirstPropertyXMLName(), mandatory);
    }

    protected void storeStaticAttribute(Node parentNode, String attributeName, String namespace, Object value) {
        if (parentNode != null) {
            Document document = this.getDocument(parentNode);
            Attr attribute = document.createAttributeNS(namespace, attributeName);
            attribute.setTextContent(this.castObjectValue(value));
            parentNode.getAttributes().setNamedItem(attribute);
        }
    }

    protected Object getObjectValue(String classAttribute, Object object) {
        if (object != null) {
            if (object instanceof Resource && classAttribute.startsWith("resource.")) {
                classAttribute = classAttribute.substring(9);
            }
            String[] attributes = classAttribute.split("\\.");
            Object result = this.getObjectValueForAttribute(attributes[0], object);
            for (int i = 1; i < attributes.length && result != null; ++i) {
                result = this.getObjectValueForAttribute(attributes[i], result);
            }
            return result;
        }
        return null;
    }

    private Object getObjectValueForAttribute(String classAttribute, Object object) {
        Class<?> objectClass = object.getClass();
        Method getterMethod = null;
        String propertyName = this.capitalizePropertyName(classAttribute);
        try {
            getterMethod = this.findGetter(objectClass, "get" + propertyName);
            if (getterMethod == null) {
                getterMethod = this.findGetter(objectClass, "is" + propertyName);
            }
        }
        catch (SecurityException e) {
            log.error(String.format("Cannot access getter for class attribute %s: %s", classAttribute, e.getMessage()));
        }
        if (getterMethod != null) {
            try {
                Class<?>[] parameterTypes = getterMethod.getParameterTypes();
                if (parameterTypes != null && parameterTypes.length == 1 && HostInfo.class.isAssignableFrom(parameterTypes[0])) {
                    return getterMethod.invoke(object, this.getHostInfo());
                }
                return getterMethod.invoke(object, new Object[0]);
            }
            catch (InvocationTargetException e) {
                log.error(String.format("Getter for class attribute %s cannot be invoked: %s", classAttribute, e.getTargetException().getMessage()));
            }
            catch (Exception e) {
                log.error(String.format("Getter for class attribute %s cannot be invoked: %s", classAttribute, e.getMessage()));
            }
        }
        return null;
    }

    private Method findGetter(Class<?> objectClass, String methodName) {
        for (Method m : objectClass.getMethods()) {
            if (!m.getName().equals(methodName)) continue;
            return m;
        }
        return null;
    }

    private String capitalizePropertyName(String s) {
        if (s.length() == 0) {
            return s;
        }
        char[] chars = s.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    private Document getDocument(Node parentNode) {
        Document document = parentNode.getOwnerDocument();
        if (document == null) {
            document = (Document)parentNode;
        }
        return document;
    }

    private boolean fieldIncluded(ClassProperties fieldName) {
        return this.includedFields == null || this.includedFieldsContainsAnyPropertyFilterName(fieldName);
    }

    protected boolean isResourceRequired() {
        return this.includedFields == null || this.includedFieldsContainsAnyPropertyFilterName(ClassProperties.RESOURCE_URL) || this.includedFieldsContainsAnyPropertyFilterName(ClassProperties.RESOURCE_DURATION) || this.includedFieldsContainsAnyPropertyFilterName(ClassProperties.RESOURCE_PROTOCOLINFO) || this.includedFieldsContainsAnyPropertyFilterName(ClassProperties.RESOURCE_SIZE) || this.includedFieldsContainsAnyPropertyFilterName(ClassProperties.RESOURCE_BITRATE) || this.includedFieldsContainsAnyPropertyFilterName(ClassProperties.RESOURCE_CHANNELS) || this.includedFieldsContainsAnyPropertyFilterName(ClassProperties.RESOURCE_SAMPLE_FREQUENCY) || this.includedFieldsContainsAnyPropertyFilterName(ClassProperties.RESOURCE_RESOLUTION) || this.includedFieldsContainsAnyPropertyFilterName(ClassProperties.RESOURCE_COLOR_DEPTH);
    }

    protected boolean includedFieldsContainsAnyPropertyFilterName(ClassProperties field) {
        if (this.includedFields == null) {
            return true;
        }
        for (String fieldName : field.getPropertyFilterNames()) {
            if (!this.includedFields.contains(StringUtils.localeSafeToLowercase(fieldName))) continue;
            return true;
        }
        return false;
    }

    private String castObjectValue(Object value) {
        if (value instanceof ObjectClassType) {
            return ((ObjectClassType)((Object)value)).getClassName();
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? "1" : "0";
        }
        return XmlUtils.objectToXMLType(value);
    }

    private String encodeString(String value) {
        value = value.replaceAll("\\\\", "\\\\\\\\");
        value = value.replaceAll(",", "\\\\,");
        return value;
    }

    static {
        try {
            xmlBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            log.error("Cannot instantiate XML builder.", (Throwable)e);
        }
    }
}

