/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.upnp.service.contentdirectory;

import java.util.ArrayList;
import org.serviio.library.metadata.MediaFileType;
import org.serviio.upnp.service.contentdirectory.ProtocolAdditionalInfo;
import org.serviio.util.CollectionUtils;

public class DLNAProtocolAdditionalInfo
implements ProtocolAdditionalInfo {
    protected static final String ATTR_PN = "DLNA.ORG_PN";
    protected static final String ATTR_OP = "DLNA.ORG_OP";
    protected static final String ATTR_CI = "DLNA.ORG_CI";
    protected static final String ATTR_FLAGS = "DLNA.ORG_FLAGS";
    protected static final String FLAGS_RESERVED_DATA = "000000000000000000000000";
    protected String profileName;

    public DLNAProtocolAdditionalInfo(String profileName) {
        this.profileName = profileName;
    }

    @Override
    public String buildMediaProtocolInfo(boolean transcoded, boolean live, MediaFileType fileType, boolean durationAvailable) {
        ArrayList<String> fieldValues = new ArrayList<String>();
        if (this.profileName != null) {
            fieldValues.add("DLNA.ORG_PN=" + this.profileName);
        }
        fieldValues.add("DLNA.ORG_OP=" + this.getFileOperations(transcoded, live, fileType, durationAvailable));
        if (transcoded) {
            fieldValues.add("DLNA.ORG_CI=1");
        } else {
            fieldValues.add("DLNA.ORG_CI=0");
        }
        fieldValues.add("DLNA.ORG_FLAGS=" + this.getFileProfileFlags(transcoded, live, fileType));
        return CollectionUtils.listToCSV(fieldValues, ";", false);
    }

    @Override
    public String buildProfileProtocolInfo(MediaFileType fileType) {
        ArrayList<String> fieldValues = new ArrayList<String>();
        if (this.profileName != null) {
            fieldValues.add("DLNA.ORG_PN=" + this.profileName);
        }
        fieldValues.add("DLNA.ORG_OP=" + this.getProfileOperations(fileType));
        fieldValues.add("DLNA.ORG_FLAGS=" + this.getProfileFlags(fileType));
        return CollectionUtils.listToCSV(fieldValues, ";", false);
    }

    private String getFileOperations(boolean transcoded, boolean live, MediaFileType fileType, boolean durationAvailable) {
        if (fileType == MediaFileType.IMAGE) {
            return "00";
        }
        if (fileType == MediaFileType.AUDIO || fileType == MediaFileType.VIDEO) {
            if (live) {
                return "00";
            }
            if (transcoded) {
                if (durationAvailable) {
                    return "10";
                }
                return "00";
            }
            return "01";
        }
        return "00";
    }

    private String getProfileOperations(MediaFileType fileType) {
        if (fileType == MediaFileType.IMAGE) {
            return "00";
        }
        if (fileType == MediaFileType.AUDIO) {
            return "01";
        }
        if (fileType == MediaFileType.VIDEO) {
            return "11";
        }
        return "00";
    }

    private String getFileProfileFlags(boolean transcoded, boolean live, MediaFileType fileType) {
        if (fileType == MediaFileType.IMAGE) {
            return this.generateFlagsHexNumber(Long.parseLong("00000000110100000000000000000000", 2));
        }
        if (fileType == MediaFileType.AUDIO || fileType == MediaFileType.VIDEO) {
            if (live) {
                return this.generateFlagsHexNumber(Long.parseLong("10001101010100000000000000000000", 2));
            }
            return this.generateFlagsHexNumber(Long.parseLong("00000001010100000000000000000000", 2));
        }
        return "*";
    }

    private String getProfileFlags(MediaFileType fileType) {
        if (fileType == MediaFileType.IMAGE) {
            return this.generateFlagsHexNumber(Long.parseLong("00000000110100000000000000000000", 2));
        }
        if (fileType == MediaFileType.AUDIO || fileType == MediaFileType.VIDEO) {
            return this.generateFlagsHexNumber(Long.parseLong("10000001010100000000000000000000", 2));
        }
        return "*";
    }

    protected String generateFlagsHexNumber(long primaryFlags) {
        return String.format("%08X%s", primaryFlags, FLAGS_RESERVED_DATA);
    }
}

