/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.upnp.service.contentdirectory;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.serviio.library.entities.AccessGroup;
import org.serviio.profile.Profile;
import org.serviio.upnp.service.contentdirectory.BrowseItemsHolder;
import org.serviio.upnp.service.contentdirectory.CDSCacheDecorator;
import org.serviio.upnp.service.contentdirectory.InvalidBrowseFlagException;
import org.serviio.upnp.service.contentdirectory.LocalContentCacheDecorator;
import org.serviio.upnp.service.contentdirectory.NoCacheDecorator;
import org.serviio.upnp.service.contentdirectory.ObjectNotFoundException;
import org.serviio.upnp.service.contentdirectory.ObjectType;
import org.serviio.upnp.service.contentdirectory.classes.DirectoryObject;
import org.serviio.upnp.service.contentdirectory.definition.ContainerNode;
import org.serviio.upnp.service.contentdirectory.definition.Definition;

public class ContentDirectoryEngine {
    private static final String CACHE_REGION_LOCAL_DEFAULT = "local_default";
    private static final String CACHE_REGION_LOCAL_RESET_AFTER_PLAY = "local_resetafterplay";
    private static final String CACHE_REGION_NO_CACHE = "no_cache";
    private static final String BROWSE_FLAG_BrowseMetadata = "BrowseMetadata";
    private static final String BROWSE_FLAG_BrowseDirectChildren = "BrowseDirectChildren";
    private static ContentDirectoryEngine instance;
    private Map<String, CDSCacheDecorator> cacheRegions;

    private ContentDirectoryEngine() {
        this.setupCache();
    }

    public static ContentDirectoryEngine getInstance() {
        if (instance == null) {
            instance = new ContentDirectoryEngine();
        }
        return instance;
    }

    public BrowseItemsHolder<DirectoryObject> browse(String objectID, ObjectType objectType, String browseFlag, String filter, int startingIndex, int requestedCount, String sortCriteria, Profile rendererProfile, AccessGroup accessGroup, boolean disablePresentationSettings) {
        ContainerNode container;
        if (!browseFlag.equals(BROWSE_FLAG_BrowseMetadata) && !browseFlag.equals(BROWSE_FLAG_BrowseDirectChildren)) {
            throw new InvalidBrowseFlagException(String.format("Unsupported browse flag: %s", browseFlag));
        }
        if (rendererProfile.getContentDirectoryDefinitionFilter() != null) {
            objectID = rendererProfile.getContentDirectoryDefinitionFilter().filterObjectId(objectID, false);
        }
        if ((container = Definition.instance().getContainer(objectID)) == null) {
            throw new ObjectNotFoundException();
        }
        BrowseItemsHolder<DirectoryObject> itemsHolder = this.getCacheRegion(container.getCacheRegion()).retrieve(objectID, objectType, browseFlag, filter, startingIndex, requestedCount, sortCriteria, rendererProfile, accessGroup, disablePresentationSettings);
        if (itemsHolder == null) {
            boolean storeInCache = true;
            itemsHolder = new BrowseItemsHolder();
            if (browseFlag.equals(BROWSE_FLAG_BrowseDirectChildren)) {
                itemsHolder = container.retrieveContainerItems(objectID, objectType, null, startingIndex, requestedCount, rendererProfile, accessGroup, disablePresentationSettings);
            } else {
                DirectoryObject object = container.retrieveDirectoryObject(objectID, objectType, rendererProfile, accessGroup, disablePresentationSettings);
                if (object != null) {
                    itemsHolder.setTotalMatched(1);
                    itemsHolder.setItems(Collections.singletonList(object));
                } else {
                    storeInCache = false;
                }
            }
            if (storeInCache) {
                this.getCacheRegion(container.getCacheRegion()).store(itemsHolder, objectID, objectType, browseFlag, filter, startingIndex, requestedCount, sortCriteria, rendererProfile, accessGroup, disablePresentationSettings);
            }
        }
        return itemsHolder;
    }

    public void evictItemsAfterPlay() {
        this.cacheRegions.get(CACHE_REGION_LOCAL_RESET_AFTER_PLAY).evictAll();
    }

    void clearAllCacheRegions() {
        for (Map.Entry<String, CDSCacheDecorator> entry : this.cacheRegions.entrySet()) {
            entry.getValue().evictAll();
        }
    }

    private void setupCache() {
        this.cacheRegions = new HashMap<String, CDSCacheDecorator>();
        this.cacheRegions.put(CACHE_REGION_LOCAL_DEFAULT, new LocalContentCacheDecorator(CACHE_REGION_LOCAL_DEFAULT));
        this.cacheRegions.put(CACHE_REGION_LOCAL_RESET_AFTER_PLAY, new LocalContentCacheDecorator(CACHE_REGION_LOCAL_RESET_AFTER_PLAY));
        this.cacheRegions.put(CACHE_REGION_NO_CACHE, new NoCacheDecorator());
    }

    private CDSCacheDecorator getCacheRegion(String regionName) {
        return this.cacheRegions.get(regionName);
    }
}

