/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.upnp.service.contentdirectory;

import java.lang.reflect.Constructor;
import org.serviio.library.entities.AccessGroup;
import org.serviio.library.entities.MediaItem;
import org.serviio.library.local.service.MediaService;
import org.serviio.library.service.AccessGroupService;
import org.serviio.profile.Profile;
import org.serviio.profile.ProfileManager;
import org.serviio.renderer.entities.Renderer;
import org.serviio.upnp.protocol.soap.InvocationError;
import org.serviio.upnp.protocol.soap.OperationResult;
import org.serviio.upnp.protocol.soap.SOAPParameter;
import org.serviio.upnp.protocol.soap.SOAPParameters;
import org.serviio.upnp.service.Service;
import org.serviio.upnp.service.StateVariable;
import org.serviio.upnp.service.contentdirectory.BrowseItemsHolder;
import org.serviio.upnp.service.contentdirectory.ContentDirectoryEngine;
import org.serviio.upnp.service.contentdirectory.ContentDirectoryMessageBuilder;
import org.serviio.upnp.service.contentdirectory.InvalidBrowseFlagException;
import org.serviio.upnp.service.contentdirectory.ObjectNotFoundException;
import org.serviio.upnp.service.contentdirectory.ObjectType;
import org.serviio.upnp.service.contentdirectory.SearchCriteria;
import org.serviio.upnp.service.contentdirectory.classes.DirectoryObject;
import org.serviio.upnp.service.contentdirectory.definition.ContainerNode;
import org.serviio.upnp.service.contentdirectory.definition.Definition;
import org.serviio.util.XmlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class ContentDirectory
extends Service {
    private static final Logger log = LoggerFactory.getLogger(ContentDirectory.class);
    private static final String VAR_A_ARG_TYPE_SortCriteria = "A_ARG_TYPE_SortCriteria";
    private static final String VAR_A_ARG_TYPE_UpdateID = "A_ARG_TYPE_UpdateID";
    private static final String VAR_A_ARG_TYPE_SearchCriteria = "A_ARG_TYPE_SearchCriteria";
    private static final String VAR_A_ARG_TYPE_Index = "A_ARG_TYPE_Index";
    private static final String VAR_A_ARG_TYPE_TagValueList = "A_ARG_TYPE_TagValueList";
    private static final String VAR_SortCapabilities = "SortCapabilities";
    private static final String VAR_SearchCapabilities = "SearchCapabilities";
    private static final String VAR_A_ARG_TYPE_Count = "A_ARG_TYPE_Count";
    private static final String VAR_A_ARG_TYPE_BrowseFlag = "A_ARG_TYPE_BrowseFlag";
    private static final String VAR_SystemUpdateID = "SystemUpdateID";
    private static final String VAR_A_ARG_TYPE_BrowseLetter = "A_ARG_TYPE_BrowseLetter";
    private static final String VAR_A_ARG_TYPE_URI = "A_ARG_TYPE_URI";
    private static final String VAR_A_ARG_TYPE_Featurelist = "A_ARG_TYPE_Featurelist";
    private static final int BOOKMARK_OFFSET = 10;
    private ContentDirectoryEngine engine;

    @Override
    protected void setupService() {
        this.serviceId = "urn:upnp-org:serviceId:ContentDirectory";
        this.serviceType = "urn:schemas-upnp-org:service:ContentDirectory:1";
        this.setupStateVariables();
        this.engine = ContentDirectoryEngine.getInstance();
    }

    public OperationResult GetSystemUpdateID() {
        OperationResult result = new OperationResult();
        result.addOutputParameter("Id", this.getStateVariable(VAR_SystemUpdateID).getValue());
        return result;
    }

    public OperationResult GetSearchCapabilities() {
        OperationResult result = new OperationResult();
        result.addOutputParameter("SearchCaps", this.getStateVariable(VAR_SearchCapabilities).getValue());
        return result;
    }

    public OperationResult GetSortCapabilities() {
        OperationResult result = new OperationResult();
        result.addOutputParameter("SortCaps", this.getStateVariable(VAR_SortCapabilities).getValue());
        return result;
    }

    public OperationResult Browse(@SOAPParameters(value={@SOAPParameter(value="ObjectID"), @SOAPParameter(value="ContainerID")}) String objectID, @SOAPParameter(value="BrowseFlag") String browseFlag, @SOAPParameter(value="Filter") String filter, @SOAPParameter(value="StartingIndex") int startingIndex, @SOAPParameter(value="RequestedCount") int requestedCount, @SOAPParameter(value="SortCriteria") String sortCriteria, Renderer renderer) {
        if (renderer != null) {
            log.debug(String.format("Browse() called for renderer %s (profile %s) with parameters: objectID = %s, browseFlag = %s, filter = %s, startIndex = %s, count = %s, sortCriteria = %s", renderer.getName(), renderer.getProfileId(), objectID, browseFlag, filter, startingIndex, requestedCount, sortCriteria));
        } else {
            log.debug(String.format("Browse() called for unknown renderer with parameters: objectID = %s, browseFlag = %s, filter = %s, startIndex = %s, count = %s, sortCriteria = %s", objectID, browseFlag, filter, startingIndex, requestedCount, sortCriteria));
        }
        OperationResult result = new OperationResult();
        Profile rendererProfile = ProfileManager.getProfile(renderer);
        AccessGroup userProfile = AccessGroupService.getAccessGroupForRenderer(renderer);
        try {
            BrowseItemsHolder<DirectoryObject> itemsHolder = this.engine.browse(objectID, ObjectType.ALL, browseFlag, filter, startingIndex, requestedCount, sortCriteria, rendererProfile, userProfile, false);
            this.setupSuccessfulResult(result, itemsHolder, filter, rendererProfile);
        }
        catch (ObjectNotFoundException e) {
            log.warn(String.format("Object with id %s doesn't exist", objectID));
            result.setError(InvocationError.CON_MAN_NO_SUCH_OBJECT);
        }
        catch (InvalidBrowseFlagException e) {
            log.warn(e.getMessage());
            result.setError(InvocationError.INVALID_ARGS);
            return result;
        }
        catch (Exception e) {
            log.warn(String.format("Browse for object id %s failed with exception: %s", objectID, e.getMessage()), (Throwable)e);
            result.setError(InvocationError.ACTION_FAILED);
        }
        return result;
    }

    public OperationResult Search(@SOAPParameter(value="ContainerID") String containerID, @SOAPParameter(value="SearchCriteria") String searchCriteria, @SOAPParameter(value="Filter") String filter, @SOAPParameter(value="StartingIndex") int startingIndex, @SOAPParameter(value="RequestedCount") int requestedCount, @SOAPParameter(value="SortCriteria") String sortCriteria, Renderer renderer) {
        log.debug(String.format("Search() called for renderer %s with parameters: containerID = %s, searchCriteria = %s, filter = %s, startIndex = %s, count = %s, sortCriteria = %s", renderer != null ? renderer.getName() : "Unknown", containerID, searchCriteria, filter, startingIndex, requestedCount, sortCriteria));
        OperationResult result = new OperationResult();
        Profile rendererProfile = ProfileManager.getProfile(renderer);
        AccessGroup userProfile = AccessGroupService.getAccessGroupForRenderer(renderer);
        try {
            ContainerNode container;
            if (rendererProfile.getContentDirectoryDefinitionFilter() != null) {
                containerID = rendererProfile.getContentDirectoryDefinitionFilter().filterObjectId(containerID, true);
            }
            if ((container = Definition.instance().getContainer(containerID)) == null) {
                log.warn(String.format("Object with id %s doesn't exist", containerID));
                result.setError(InvocationError.CON_MAN_NO_SUCH_OBJECT);
                return result;
            }
            BrowseItemsHolder<DirectoryObject> itemsHolder = container.retrieveContainerItems(containerID, ObjectType.ALL, SearchCriteria.parse(searchCriteria), startingIndex, requestedCount, rendererProfile, userProfile, false);
            this.setupSuccessfulResult(result, itemsHolder, filter, rendererProfile);
        }
        catch (ObjectNotFoundException e) {
            log.warn(String.format("Container with id %s doesn't exist", containerID));
            result.setError(InvocationError.CON_MAN_NO_SUCH_OBJECT);
        }
        catch (Exception e) {
            log.warn(String.format("Search in container %s failed with exception: %s", containerID, e.getMessage()), (Throwable)e);
            result.setError(InvocationError.ACTION_FAILED);
        }
        return result;
    }

    public OperationResult X_SetBookmark(@SOAPParameter(value="CategoryType") int categoryType, @SOAPParameter(value="RID") int rid, @SOAPParameter(value="ObjectID") String objectID, @SOAPParameter(value="PosSecond") int posSecond, Renderer renderer) {
        OperationResult result = new OperationResult();
        if (renderer == null) {
            log.warn("No associated Renderer exists for the request, will not bookmark the last viewed position");
        } else {
            ContainerNode container = Definition.instance().getContainer(objectID);
            if (container == null) {
                log.warn(String.format("Object with id %s doesn't exist", objectID));
                result.setError(InvocationError.CON_MAN_NO_SUCH_OBJECT);
            } else {
                Profile rendererProfile = ProfileManager.getProfile(renderer);
                DirectoryObject object = container.retrieveDirectoryObject(objectID, ObjectType.ALL, rendererProfile, AccessGroup.ANY, false);
                if (object != null && object.getEntityId() != null) {
                    if (MediaItem.isLocalMedia(object.getEntityId())) {
                        int position = posSecond >= 10 ? posSecond - 10 : 0;
                        MediaService.setMediaItemBookmark(object.getEntityId(), position);
                        this.engine.clearAllCacheRegions();
                    }
                } else {
                    log.warn(String.format("ObjectId %s is not recognized, will not bookmark the last viewed position", objectID));
                }
            }
        }
        return result;
    }

    public OperationResult X_GetFeatureList() {
        OperationResult result = new OperationResult();
        result.addOutputParameter("FeatureList", this.getStateVariable(VAR_A_ARG_TYPE_Featurelist).getValue());
        return result;
    }

    public synchronized void incrementUpdateID() {
        this.incrementUpdateID(true);
    }

    public synchronized void incrementUpdateID(boolean cleanCache) {
        Integer currentValue;
        Integer n = currentValue = (Integer)this.getStateVariable(VAR_SystemUpdateID).getValue();
        Integer n2 = currentValue = Integer.valueOf(currentValue + 1);
        this.setStateVariable(VAR_SystemUpdateID, currentValue);
        if (cleanCache) {
            this.engine.clearAllCacheRegions();
        }
    }

    private void setupStateVariables() {
        this.stateVariables.add(new StateVariable(VAR_A_ARG_TYPE_SortCriteria, null));
        this.stateVariables.add(new StateVariable(VAR_A_ARG_TYPE_UpdateID, null));
        this.stateVariables.add(new StateVariable(VAR_A_ARG_TYPE_SearchCriteria, null));
        this.stateVariables.add(new StateVariable(VAR_A_ARG_TYPE_Index, null));
        this.stateVariables.add(new StateVariable(VAR_A_ARG_TYPE_TagValueList, null));
        this.stateVariables.add(new StateVariable(VAR_SortCapabilities, ""));
        this.stateVariables.add(new StateVariable(VAR_SearchCapabilities, ""));
        this.stateVariables.add(new StateVariable(VAR_A_ARG_TYPE_Count, null));
        this.stateVariables.add(new StateVariable(VAR_A_ARG_TYPE_BrowseFlag, null));
        this.stateVariables.add(new StateVariable(VAR_SystemUpdateID, new Integer(1), true, 2000));
        this.stateVariables.add(new StateVariable(VAR_A_ARG_TYPE_BrowseLetter, null));
        this.stateVariables.add(new StateVariable(VAR_A_ARG_TYPE_URI, null));
        this.stateVariables.add(new StateVariable(VAR_A_ARG_TYPE_Featurelist, "<?xml version=\"1.0\" encoding=\"UTF-8\"?><Features xmlns=\"urn:schemas-upnp-org:av:avs\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\" urn:schemas-upnp-org:av:avs http://www.upnp.org/schemas/av/avs.xsd\"><Feature name=\"samsung.com_BASICVIEW\" version=\"1\"><container id=\"I\" type=\"object.item.imageItem\"/><container id=\"A\" type=\"object.item.audioItem\"/><container id=\"V\" type=\"object.item.videoItem\"/></Feature></Features>"));
    }

    private void setupSuccessfulResult(OperationResult result, BrowseItemsHolder<DirectoryObject> itemsHolder, String filter, Profile rendererProfile) {
        ContentDirectoryMessageBuilder messageBuilder = this.instantiateMessageBuilder(filter, rendererProfile);
        Document xmlDocument = messageBuilder.buildXML(itemsHolder.getItems());
        result.addOutputParameter("Result", XmlUtils.getStringFromDocument(xmlDocument, true));
        result.addOutputParameter("NumberReturned", itemsHolder.getReturnedSize());
        result.addOutputParameter("TotalMatches", itemsHolder.getTotalMatched());
        result.addOutputParameter("UpdateID", this.getStateVariable(VAR_SystemUpdateID).getValue());
    }

    private <T extends ContentDirectoryMessageBuilder> ContentDirectoryMessageBuilder instantiateMessageBuilder(String filter, Profile rendererProfile) {
        Class<?> builderClass = rendererProfile.getContentDirectoryMessageBuilder();
        if (builderClass == null) {
            throw new RuntimeException("MessageBuilder class not defined in Profile");
        }
        try {
            Constructor<?> c = builderClass.getConstructor(String.class);
            return (ContentDirectoryMessageBuilder)c.newInstance(filter);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Cannot instantiate ContentDirectoryMessageBuilder. Message: %s", e.getMessage()), e);
        }
    }
}

