/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.upnp.service.connectionmanager;

import java.util.LinkedHashSet;
import java.util.Map;
import org.serviio.dlna.MediaFormatProfile;
import org.serviio.profile.Profile;
import org.serviio.profile.ProfileManager;
import org.serviio.renderer.entities.Renderer;
import org.serviio.upnp.protocol.soap.InvocationError;
import org.serviio.upnp.protocol.soap.OperationResult;
import org.serviio.upnp.protocol.soap.SOAPParameter;
import org.serviio.upnp.service.Service;
import org.serviio.upnp.service.StateVariable;
import org.serviio.upnp.service.contentdirectory.ProtocolInfo;
import org.serviio.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionManager
extends Service {
    private static final Logger log = LoggerFactory.getLogger(ConnectionManager.class);
    private static final int CONNECTION_ID = 0;
    private static final String VAR_A_ARG_TYPE_ProtocolInfo = "A_ARG_TYPE_ProtocolInfo";
    private static final String VAR_A_ARG_TYPE_ConnectionStatus = "A_ARG_TYPE_ConnectionStatus";
    private static final String VAR_SinkProtocolInfo = "SinkProtocolInfo";
    private static final String VAR_A_ARG_TYPE_ConnectionID = "A_ARG_TYPE_ConnectionID";
    private static final String VAR_SourceProtocolInfo = "SourceProtocolInfo";
    private static final String VAR_CurrentConnectionIDs = "CurrentConnectionIDs";
    private static final String VAR_A_ARG_TYPE_AVTransportID = "A_ARG_TYPE_AVTransportID";
    private static final String VAR_A_ARG_TYPE_RcsID = "A_ARG_TYPE_RcsID";
    private static final String VAR_A_ARG_TYPE_ConnectionManager = "A_ARG_TYPE_ConnectionManager";
    private static final String VAR_A_ARG_TYPE_Direction = "A_ARG_TYPE_Direction";

    @Override
    protected void setupService() {
        this.serviceId = "urn:upnp-org:serviceId:ConnectionManager";
        this.serviceType = "urn:schemas-upnp-org:service:ConnectionManager:1";
        this.setupStateVariables();
    }

    private void setupStateVariables() {
        this.stateVariables.add(new StateVariable(VAR_A_ARG_TYPE_ProtocolInfo, null));
        this.stateVariables.add(new StateVariable(VAR_A_ARG_TYPE_ConnectionStatus, "OK"));
        this.stateVariables.add(new StateVariable(VAR_SinkProtocolInfo, null, true, 0));
        this.stateVariables.add(new StateVariable(VAR_A_ARG_TYPE_ConnectionID, 0));
        this.stateVariables.add(new StateVariable(VAR_SourceProtocolInfo, null, true, 0));
        this.stateVariables.add(new StateVariable(VAR_CurrentConnectionIDs, Integer.toString(0), true, 0));
        this.stateVariables.add(new StateVariable(VAR_A_ARG_TYPE_AVTransportID, "-1"));
        this.stateVariables.add(new StateVariable(VAR_A_ARG_TYPE_RcsID, "-1"));
        this.stateVariables.add(new StateVariable(VAR_A_ARG_TYPE_ConnectionManager, null));
        this.stateVariables.add(new StateVariable(VAR_A_ARG_TYPE_Direction, "Output"));
    }

    public OperationResult GetProtocolInfo(Renderer renderer) {
        Profile rendererProfile = ProfileManager.getProfile(renderer);
        OperationResult result = new OperationResult();
        result.addOutputParameter("Source", this.getSourceProtocolInfo(rendererProfile));
        result.addOutputParameter("Sink", this.getStateVariable(VAR_SinkProtocolInfo).getValue());
        return result;
    }

    public OperationResult GetCurrentConnectionIDs() {
        OperationResult result = new OperationResult();
        result.addOutputParameter("ConnectionIDs", this.getStateVariable(VAR_CurrentConnectionIDs).getValue());
        return result;
    }

    public OperationResult GetCurrentConnectionInfo(@SOAPParameter(value="ConnectionID") Integer connectionId) {
        OperationResult result = new OperationResult();
        if (connectionId == null || !connectionId.equals(this.getStateVariable(VAR_A_ARG_TYPE_ConnectionID).getValue())) {
            result.setError(InvocationError.CON_MAN_INVALID_CONNECTION_REFERENCE);
        } else {
            result.addOutputParameter("RcsID", this.getStateVariable(VAR_A_ARG_TYPE_RcsID).getValue());
            result.addOutputParameter("AVTransportID", this.getStateVariable(VAR_A_ARG_TYPE_AVTransportID).getValue());
            result.addOutputParameter("ProtocolInfo", this.getStateVariable(VAR_A_ARG_TYPE_ProtocolInfo).getValue());
            result.addOutputParameter("PeerConnectionManager", this.getStateVariable(VAR_A_ARG_TYPE_ConnectionManager).getValue());
            result.addOutputParameter("PeerConnectionID", this.getStateVariable(VAR_A_ARG_TYPE_ConnectionID).getValue());
            result.addOutputParameter("Direction", this.getStateVariable(VAR_A_ARG_TYPE_Direction).getValue());
            result.addOutputParameter("Status", this.getStateVariable(VAR_A_ARG_TYPE_ConnectionStatus).getValue());
        }
        return result;
    }

    private String getSourceProtocolInfo(Profile profile) {
        log.debug(String.format("Sending protocol info using profile '%s'", profile));
        LinkedHashSet<String> protocolInfos = new LinkedHashSet<String>();
        for (Map.Entry<MediaFormatProfile, ProtocolInfo> entry : profile.getProtocolInfo().entrySet()) {
            protocolInfos.addAll(entry.getValue().getProfileProtocolInfo(entry.getKey().getFileType()));
        }
        return CollectionUtils.listToCSV(protocolInfos, ",", false);
    }
}

