/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.upnp.service;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import org.serviio.upnp.Device;
import org.serviio.upnp.eventing.EventDispatcher;
import org.serviio.upnp.eventing.Subscription;
import org.serviio.upnp.service.StateVariable;
import org.serviio.upnp.webserver.WebServer;

public abstract class Service {
    protected String serviceId;
    protected String serviceType;
    protected String scpdURL;
    protected String controlURL;
    protected String eventSubURL;
    protected Set<StateVariable> stateVariables = new HashSet<StateVariable>();
    protected Set<Subscription> eventSubscriptions = new ConcurrentSkipListSet<Subscription>();

    public Service() {
        this.setupService();
        this.scpdURL = this.resolveDescriptionURL();
        this.controlURL = this.resolveControlURL();
        this.eventSubURL = this.resolveEventingURL();
    }

    protected abstract void setupService();

    public void addEventSubscription(Subscription subscription) {
        this.eventSubscriptions.add(subscription);
    }

    public void removeEventSubscription(Subscription subscription) {
        this.eventSubscriptions.remove(subscription);
    }

    public Subscription getEventSubscription(String subscriptionId) {
        for (Subscription sub : this.eventSubscriptions) {
            if (!sub.getUuid().equals(subscriptionId)) continue;
            return sub;
        }
        return null;
    }

    public Subscription getEventSubscription(URL deliveryURL) {
        for (Subscription sub : this.eventSubscriptions) {
            if (!sub.getDeliveryURL().equals(deliveryURL)) continue;
            return sub;
        }
        return null;
    }

    public StateVariable getStateVariable(String name) {
        for (StateVariable variable : this.stateVariables) {
            if (!variable.getName().equals(name)) continue;
            return variable;
        }
        return null;
    }

    public void setStateVariable(String name, Object value) {
        StateVariable var = this.getStateVariable(name);
        if (var != null) {
            var.setValue(value);
            EventDispatcher.addEvent(this, var, null);
        }
    }

    public Set<StateVariable> getStateVariablesWithEventing() {
        HashSet<StateVariable> variables = new HashSet<StateVariable>();
        for (StateVariable variable : this.stateVariables) {
            if (!variable.isSupportsEventing()) continue;
            variables.add(variable);
        }
        return variables;
    }

    public String getShortName() {
        return this.serviceId.substring(this.serviceId.lastIndexOf(":") + 1);
    }

    protected String resolveDescriptionURL() {
        try {
            return new URL("http", Device.getInstance().getBindAddress().getHostAddress(), WebServer.WEBSERVER_PORT, "/serviceDescription/" + this.getShortName()).getPath();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Cannot resolve Service description URL address. Exiting.");
        }
    }

    protected String resolveControlURL() {
        try {
            return new URL("http", Device.getInstance().getBindAddress().getHostAddress(), WebServer.WEBSERVER_PORT, "/serviceControl").getPath();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Cannot resolve Service control URL address. Exiting.");
        }
    }

    protected String resolveEventingURL() {
        try {
            return new URL("http", Device.getInstance().getBindAddress().getHostAddress(), WebServer.WEBSERVER_PORT, "/serviceEventing/" + this.getShortName()).getPath();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Cannot resolve Service eventing URL address. Exiting.");
        }
    }

    public String getScpdURL() {
        return this.scpdURL;
    }

    public String getControlURL() {
        return this.controlURL;
    }

    public String getEventSubURL() {
        return this.eventSubURL;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public Set<Subscription> getEventSubscriptions() {
        return this.eventSubscriptions;
    }

    public boolean equals(Object obj) {
        return obj instanceof Service && ((Service)obj).getServiceId().equals(this.serviceId);
    }

    public int hashCode() {
        return this.serviceId.hashCode();
    }
}

