/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.upnp.protocol.ssdp;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.http.HttpResponse;
import org.serviio.upnp.Device;
import org.serviio.upnp.protocol.http.HttpMessageBuilder;
import org.serviio.upnp.protocol.ssdp.InsufficientInformationException;
import org.serviio.upnp.protocol.ssdp.SSDPConstants;
import org.serviio.upnp.protocol.ssdp.SSDPResponseMessageBuilder;
import org.serviio.upnp.service.Service;
import org.serviio.util.DateUtils;
import org.serviio.util.ObjectValidator;

public class SearchResponseMessageBuilder
extends SSDPResponseMessageBuilder {
    @Override
    public List<String> generateSSDPMessages(Integer duration, String searchTarget) throws InsufficientInformationException {
        if (duration == null || duration < 0) {
            throw new InsufficientInformationException(String.format("Message duration includes invalid value: %s", duration));
        }
        if (ObjectValidator.isEmpty(searchTarget)) {
            throw new InsufficientInformationException(String.format("Message searchTarget includes invalid value: %s", searchTarget));
        }
        ArrayList<String> messages = new ArrayList<String>();
        Device device = Device.getInstance();
        if (searchTarget.equals("ssdp:all")) {
            messages.addAll(this.generateAllMessages(duration, device));
        } else if (searchTarget.equals("upnp:rootdevice")) {
            messages.add(this.generateRootDeviceMessage(duration, device));
        } else if (searchTarget.equals("uuid:" + device.getUuid())) {
            messages.add(this.generateDeviceByUUIDMessage(duration, device));
        } else if (searchTarget.equals(device.getDeviceType())) {
            messages.add(this.generateDeviceByTypeMessage(duration, device));
        } else if (this.isServiceSupported(searchTarget, device)) {
            messages.add(this.generateServiceMessage(duration, device, searchTarget));
        }
        return messages;
    }

    protected HttpResponse generateBase(Integer duration, Device device) {
        HttpResponse response = super.generateBase(device);
        response.addHeader("CACHE-CONTROL", "max-age = " + duration.toString());
        response.addHeader("LOCATION", device.getDescriptionURL().toString());
        response.addHeader("EXT", "");
        response.addHeader("DATE", DateUtils.formatRFC1123(new Date()));
        response.addHeader("SERVER", SSDPConstants.SERVER);
        return response;
    }

    protected List<String> generateAllServicesMessages(Integer duration, Device device) {
        ArrayList<String> result = new ArrayList<String>(3);
        for (Service service : device.getServices()) {
            result.add(this.generateServiceMessage(duration, device, service.getServiceType()));
        }
        return result;
    }

    protected List<String> generateAllMessages(Integer duration, Device device) {
        ArrayList<String> messages = new ArrayList<String>();
        messages.add(this.generateRootDeviceMessage(duration, device));
        messages.add(this.generateDeviceByUUIDMessage(duration, device));
        messages.add(this.generateDeviceByTypeMessage(duration, device));
        messages.addAll(this.generateAllServicesMessages(duration, device));
        return messages;
    }

    protected String generateRootDeviceMessage(Integer duration, Device device) {
        HttpResponse message = this.generateBase(duration, device);
        message.addHeader("ST", "upnp:rootdevice");
        message.addHeader("USN", "uuid:" + device.getUuid() + "::" + "upnp:rootdevice");
        return HttpMessageBuilder.transformToString(message);
    }

    protected String generateDeviceByUUIDMessage(Integer duration, Device device) {
        HttpResponse message = this.generateBase(duration, device);
        message.addHeader("ST", "uuid:" + device.getUuid());
        message.addHeader("USN", "uuid:" + device.getUuid());
        return HttpMessageBuilder.transformToString(message);
    }

    protected String generateDeviceByTypeMessage(Integer duration, Device device) {
        HttpResponse message = this.generateBase(duration, device);
        message.addHeader("ST", device.getDeviceType());
        message.addHeader("USN", "uuid:" + device.getUuid() + "::" + device.getDeviceType());
        return HttpMessageBuilder.transformToString(message);
    }

    protected String generateServiceMessage(Integer duration, Device device, String serviceType) {
        HttpResponse message = this.generateBase(duration, device);
        message.addHeader("ST", serviceType);
        message.addHeader("USN", "uuid:" + device.getUuid() + "::" + serviceType);
        return HttpMessageBuilder.transformToString(message);
    }

    private boolean isServiceSupported(String serviceType, Device device) {
        for (Service service : device.getServices()) {
            if (!service.getServiceType().equals(serviceType)) continue;
            return true;
        }
        return false;
    }
}

