/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.upnp.protocol.ssdp;

import java.util.HashMap;
import java.util.Map;
import org.serviio.upnp.protocol.ssdp.DeviceAliveMessageBuilder;
import org.serviio.upnp.protocol.ssdp.DeviceUnavailableMessageBuilder;
import org.serviio.upnp.protocol.ssdp.RendererSearchMessageBuilder;
import org.serviio.upnp.protocol.ssdp.SSDPRequestMessageBuilder;

public class SSDPMessageBuilderFactory {
    private static SSDPMessageBuilderFactory instance;
    private Map<SSDPMessageType, SSDPRequestMessageBuilder> builders = new HashMap<SSDPMessageType, SSDPRequestMessageBuilder>(3);

    private SSDPMessageBuilderFactory() {
        this.builders.put(SSDPMessageType.ALIVE, new DeviceAliveMessageBuilder());
        this.builders.put(SSDPMessageType.BYEBYE, new DeviceUnavailableMessageBuilder());
        this.builders.put(SSDPMessageType.SEARCH, new RendererSearchMessageBuilder());
    }

    public static SSDPMessageBuilderFactory getInstance() {
        if (instance == null) {
            instance = new SSDPMessageBuilderFactory();
        }
        return instance;
    }

    public SSDPRequestMessageBuilder getBuilder(SSDPMessageType type) {
        return this.builders.get((Object)type);
    }

    public static enum SSDPMessageType {
        ALIVE,
        BYEBYE,
        SEARCH;

    }
}

