/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.upnp.protocol.ssdp;

import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpRequest;
import org.serviio.upnp.protocol.http.HttpMessageBuilder;
import org.serviio.upnp.protocol.ssdp.InsufficientInformationException;
import org.serviio.upnp.protocol.ssdp.SSDPRequestMessageBuilder;

public class RendererSearchMessageBuilder
extends SSDPRequestMessageBuilder {
    @Override
    public List<String> generateSSDPMessages(Integer duration, String searchTarget) throws InsufficientInformationException {
        if (duration == null || duration < 0) {
            throw new InsufficientInformationException(String.format("Message wait time includes invalid value: %s", duration));
        }
        ArrayList<String> messages = new ArrayList<String>();
        messages.add(HttpMessageBuilder.transformToString(this.generateMessage("M-SEARCH", duration, searchTarget)));
        return messages;
    }

    protected HttpRequest generateMessage(String method, Integer duration, String searchTarget) {
        HttpRequest request = super.generateBase(method);
        request.addHeader("MAN", "\"ssdp:discover\"");
        request.addHeader("MX", Integer.toString(duration));
        request.addHeader("ST", searchTarget);
        return request;
    }
}

