/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.upnp.protocol.ssdp;

import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpRequest;
import org.serviio.upnp.Device;
import org.serviio.upnp.protocol.http.HttpMessageBuilder;
import org.serviio.upnp.protocol.ssdp.InsufficientInformationException;
import org.serviio.upnp.protocol.ssdp.SSDPConstants;
import org.serviio.upnp.protocol.ssdp.SSDPRequestMessageBuilder;
import org.serviio.upnp.service.Service;

public class DeviceAliveMessageBuilder
extends SSDPRequestMessageBuilder {
    @Override
    public List<String> generateSSDPMessages(Integer duration, String searchTarget) throws InsufficientInformationException {
        if (duration == null || duration < 0) {
            throw new InsufficientInformationException(String.format("Message duration includes invalid value: %s", duration));
        }
        ArrayList<String> messages = new ArrayList<String>();
        messages.addAll(this.generateRootDeviceMessages(duration));
        messages.addAll(this.generateServicesMessages(duration));
        return messages;
    }

    protected HttpRequest generateBase(String method, Integer duration) {
        HttpRequest request = super.generateBase(method);
        request.addHeader("CACHE-CONTROL", "max-age = " + duration.toString());
        request.addHeader("LOCATION", Device.getInstance().getDescriptionURL().toString());
        request.addHeader("SERVER", SSDPConstants.SERVER);
        request.addHeader("NTS", "ssdp:alive");
        return request;
    }

    protected List<String> generateRootDeviceMessages(Integer duration) {
        ArrayList<String> result = new ArrayList<String>(3);
        Device device = Device.getInstance();
        HttpRequest message1 = this.generateBase("NOTIFY", duration);
        message1.addHeader("NT", "upnp:rootdevice");
        message1.addHeader("USN", "uuid:" + device.getUuid() + "::" + "upnp:rootdevice");
        result.add(HttpMessageBuilder.transformToString(message1));
        HttpRequest message2 = this.generateBase("NOTIFY", duration);
        message2.addHeader("NT", "uuid:" + device.getUuid());
        message2.addHeader("USN", "uuid:" + device.getUuid());
        result.add(HttpMessageBuilder.transformToString(message2));
        HttpRequest message3 = this.generateBase("NOTIFY", duration);
        message3.addHeader("NT", device.getDeviceType());
        message3.addHeader("USN", "uuid:" + device.getUuid() + "::" + device.getDeviceType());
        result.add(HttpMessageBuilder.transformToString(message3));
        return result;
    }

    protected List<String> generateServicesMessages(Integer duration) {
        ArrayList<String> result = new ArrayList<String>(3);
        Device device = Device.getInstance();
        for (Service service : device.getServices()) {
            HttpRequest message = this.generateBase("NOTIFY", duration);
            message.addHeader("NT", service.getServiceType());
            message.addHeader("USN", "uuid:" + device.getUuid() + "::" + service.getServiceType());
            result.add(HttpMessageBuilder.transformToString(message));
        }
        return result;
    }
}

