/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.upnp.protocol.soap;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.soap.Detail;
import javax.xml.soap.DetailEntry;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import org.serviio.renderer.entities.Renderer;
import org.serviio.upnp.Device;
import org.serviio.upnp.protocol.soap.InvocationError;
import org.serviio.upnp.protocol.soap.OperationResult;
import org.serviio.upnp.protocol.soap.SOAPParameter;
import org.serviio.upnp.protocol.soap.SOAPParameters;
import org.serviio.upnp.protocol.soap.ServiceInvocationException;
import org.serviio.upnp.service.Service;
import org.serviio.upnp.service.StateVariable;
import org.serviio.util.XmlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ServiceInvoker {
    private static final Logger log = LoggerFactory.getLogger(ServiceInvoker.class);
    private static MessageFactory messageFactory;
    private static final String QUERY_STATE_VARIABLE = "QueryStateVariable";

    public static SOAPMessage invokeService(String soapAction, String soapMessage, Renderer renderer) throws ServiceInvocationException {
        String serviceName = soapAction.substring(1, soapAction.indexOf("#"));
        String operationName = soapAction.substring(soapAction.indexOf("#") + 1, soapAction.length() - 1);
        SOAPMessage message = ServiceInvoker.parseSOAPMessage(soapMessage);
        SOAPOperationVO operation = ServiceInvoker.extractOperationValues(message);
        if (operation.getOperationName().equals(operationName)) {
            OperationResult result = ServiceInvoker.invokeOperation(serviceName, operation, renderer);
            return ServiceInvoker.createSOAPResponse(result, serviceName, operationName);
        }
        throw new ServiceInvocationException("SOAPACTION specifies a different operation than the SOAP body");
    }

    private static SOAPMessage parseSOAPMessage(String soapMessage) throws ServiceInvocationException {
        MimeHeaders mimeHeaders = new MimeHeaders();
        mimeHeaders.addHeader("Content-Type", "text/xml; charset=UTF-8");
        ByteArrayInputStream stream = new ByteArrayInputStream(soapMessage.getBytes());
        try {
            SOAPMessage message;
            SOAPMessage sOAPMessage = message = messageFactory.createMessage(mimeHeaders, (InputStream)stream);
            return sOAPMessage;
        }
        catch (IOException e) {
            throw new ServiceInvocationException("Cannot read SOAP message in order to process it", e);
        }
        catch (SOAPException e) {
            throw new ServiceInvocationException("The received SOAP message is not valid", e);
        }
        finally {
            try {
                ((InputStream)stream).close();
            }
            catch (IOException e) {}
        }
    }

    private static SOAPMessage createSOAPResponse(OperationResult result, String serviceName, String operationName) throws ServiceInvocationException {
        try {
            SOAPMessage message = messageFactory.createMessage();
            message.setProperty("javax.xml.soap.write-xml-declaration", (Object)"true");
            message.getSOAPHeader().detachNode();
            SOAPEnvelope envelope = message.getSOAPPart().getEnvelope();
            SOAPBody body = envelope.getBody();
            envelope.setEncodingStyle("http://schemas.xmlsoap.org/soap/encoding/");
            if (result.getError() != null) {
                SOAPFault fault = body.addFault(new QName(envelope.getNamespaceURI(), "Client"), "UPnPError");
                Detail faultDetail = fault.addDetail();
                DetailEntry detailEntry = faultDetail.addDetailEntry(new QName("urn:schemas-upnp-org:control-1-0", "UPnPError"));
                SOAPElement errorCodeNode = detailEntry.addChildElement(new QName("errorCode"));
                errorCodeNode.setTextContent(Integer.toString(result.getError().getCode()));
                SOAPElement errorDescription = detailEntry.addChildElement(new QName("errorDescription"));
                errorDescription.setTextContent(result.getError().getDescription());
            } else {
                SOAPBodyElement responseNode = null;
                if (operationName.equals(QUERY_STATE_VARIABLE)) {
                    responseNode = body.addBodyElement(new QName("urn:schemas-upnp-org:control-1-0", "QueryStateVariableResponse", "u"));
                    SOAPElement returnNode = responseNode.addChildElement(new QName("return"));
                    returnNode.setTextContent(XmlUtils.objectToXMLType(result.getOutputParameters().values().iterator()));
                } else {
                    responseNode = body.addBodyElement(new QName(serviceName, operationName + "Response", "u"));
                    for (Map.Entry<String, Object> parameter : result.getOutputParameters().entrySet()) {
                        SOAPElement parameterNode = responseNode.addChildElement(new QName(parameter.getKey()));
                        parameterNode.setTextContent(XmlUtils.objectToXMLType(parameter.getValue()));
                    }
                }
            }
            return message;
        }
        catch (SOAPException e) {
            throw new ServiceInvocationException();
        }
    }

    private static SOAPOperationVO extractOperationValues(SOAPMessage message) throws ServiceInvocationException {
        SOAPOperationVO operation = new SOAPOperationVO();
        try {
            SOAPBody messageBody = message.getSOAPPart().getEnvelope().getBody();
            Document doc = messageBody.extractContentAsDocument();
            Node operationNode = doc.getFirstChild();
            String operationName = operationNode.getLocalName();
            operation.setOperationName(operationName);
            for (int i = 0; i < operationNode.getChildNodes().getLength(); ++i) {
                Node parameterNode = operationNode.getChildNodes().item(i);
                if (parameterNode.getLocalName() == null) continue;
                operation.getParameters().put(parameterNode.getLocalName(), parameterNode.getTextContent());
            }
        }
        catch (SOAPException e) {
            throw new ServiceInvocationException("Cannot obtain SOAPBody in the SOAP message", e);
        }
        return operation;
    }

    private static OperationResult invokeOperation(String serviceName, SOAPOperationVO operation, Renderer renderer) throws ServiceInvocationException {
        Service service = Device.getInstance().getServiceByType(serviceName);
        if (service != null) {
            Class<?> serviceClass = service.getClass();
            Method[] methods = serviceClass.getMethods();
            if (operation.getOperationName().equals(QUERY_STATE_VARIABLE)) {
                OperationResult result = new OperationResult();
                String variableName = operation.getParameters().keySet().iterator().next();
                StateVariable variable = service.getStateVariable(variableName);
                if (variable == null) {
                    result.setError(InvocationError.INVALID_VAR);
                } else {
                    result.addOutputParameter(variableName, variable.getValue());
                }
                return result;
            }
            boolean operationNameFound = false;
            Method methodToExecute = null;
            boolean methodIsRendererSensitive = false;
            for (Method method : methods) {
                if (!method.getName().equals(operation.getOperationName())) continue;
                operationNameFound = true;
                if (method.getParameterTypes().length == operation.getParameters().size()) {
                    methodToExecute = method;
                    break;
                }
                if (method.getParameterTypes().length != operation.getParameters().size() + 1 || method.getParameterTypes()[method.getParameterTypes().length - 1] != Renderer.class) continue;
                methodToExecute = method;
                methodIsRendererSensitive = true;
                break;
            }
            if (methodToExecute == null && !operationNameFound) {
                return new OperationResult(InvocationError.INVALID_ACTION);
            }
            if (methodToExecute == null) {
                return new OperationResult(InvocationError.INVALID_ARGS);
            }
            try {
                if (!methodIsRendererSensitive) {
                    return (OperationResult)methodToExecute.invoke((Object)service, ServiceInvoker.castMethodParameters(operation.getParameters(), methodToExecute));
                }
                Object[] operationParams = ServiceInvoker.castMethodParameters(operation.getParameters(), methodToExecute);
                Object[] methodParams = Arrays.copyOf(operationParams, operationParams.length + 1);
                methodParams[methodParams.length - 1] = renderer;
                return (OperationResult)methodToExecute.invoke((Object)service, methodParams);
            }
            catch (IllegalArgumentException e) {
                log.error(String.format("Illegal parameters passed to operation %s", operation.getOperationName()), (Throwable)e);
                return new OperationResult(InvocationError.INVALID_ARGS);
            }
            catch (IllegalAccessException e) {
                log.error(String.format("Operation %s is inaccessible", operation.getOperationName()), (Throwable)e);
                return new OperationResult(InvocationError.INVALID_ACTION);
            }
            catch (InvocationTargetException e) {
                log.error(String.format("Operation %s threw an exception", operation.getOperationName()), e.getTargetException());
                return new OperationResult(InvocationError.ACTION_FAILED);
            }
        }
        throw new ServiceInvocationException(String.format("Service %s is not registered", serviceName));
    }

    private static Object[] castMethodParameters(Map<String, String> stringParameters, Method method) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        Class<?>[] parameterTypes = method.getParameterTypes();
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        int i = 0;
        for (Annotation[] annotations : parameterAnnotations) {
            Class<?> parameterType;
            if ((parameterType = parameterTypes[i++]) == Renderer.class) continue;
            Object paramValue = null;
            SOAPParameter paramAnnotation = null;
            SOAPParameters groupAnnotation = null;
            boolean found = false;
            for (Annotation annotation : annotations) {
                if (annotation instanceof SOAPParameter) {
                    paramAnnotation = (SOAPParameter)annotation;
                    paramValue = stringParameters.get(paramAnnotation.value());
                    found = true;
                } else if (annotation instanceof SOAPParameters) {
                    SOAPParameter[] paramAnnotations;
                    groupAnnotation = (SOAPParameters)annotation;
                    for (SOAPParameter alternateParamAnnotation : paramAnnotations = groupAnnotation.value()) {
                        String alternateParamValue = stringParameters.get(alternateParamAnnotation.value());
                        if (alternateParamValue == null) continue;
                        paramAnnotation = alternateParamAnnotation;
                        paramValue = alternateParamValue;
                        found = true;
                        break;
                    }
                }
                if (found) break;
            }
            if (paramAnnotation == null && groupAnnotation == null) {
                throw new RuntimeException(String.format("Parameters of method %s are not properly annotated", method.getName()));
            }
            Integer castValue = paramValue;
            if (paramValue != null && (Integer.class.isAssignableFrom(parameterType) || Integer.TYPE.isAssignableFrom(parameterType))) {
                castValue = Integer.valueOf(paramValue);
            }
            result.add(castValue);
        }
        return result.toArray(new Object[result.size()]);
    }

    static {
        try {
            messageFactory = MessageFactory.newInstance();
        }
        catch (SOAPException e) {
            log.error("Cannot create instance of SOAP MessageFactory", (Throwable)e);
        }
    }

    private static class SOAPOperationVO {
        private String operationName;
        private Map<String, String> parameters = new HashMap<String, String>();

        private SOAPOperationVO() {
        }

        public String getOperationName() {
            return this.operationName;
        }

        public void setOperationName(String operationName) {
            this.operationName = operationName;
        }

        public Map<String, String> getParameters() {
            return this.parameters;
        }
    }
}

