/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.upnp.protocol.http.transport;

import java.io.FileNotFoundException;
import org.serviio.delivery.Client;
import org.serviio.library.entities.MediaItem;
import org.serviio.upnp.protocol.http.transport.DLNAProtocolHandler;
import org.serviio.upnp.protocol.http.transport.InvalidResourceRequestException;
import org.serviio.upnp.protocol.http.transport.RequestedResourceDescriptor;
import org.serviio.upnp.service.contentdirectory.classes.InvalidResourceException;
import org.serviio.upnp.service.contentdirectory.classes.Resource;
import org.serviio.upnp.service.contentdirectory.command.ResourceValuesBuilder;

public class XBox360ProtocolHandler
extends DLNAProtocolHandler {
    private static final String ALBUM_ART_TRUE = "?albumArt=true";

    @Override
    public RequestedResourceDescriptor getRequestedResourceDescription(String requestUri, Client client) throws InvalidResourceRequestException, FileNotFoundException {
        boolean showThumbnail = requestUri.endsWith(ALBUM_ART_TRUE);
        if (showThumbnail) {
            MediaItem item;
            this.log.debug("Found request for cover art, getting the cover art details");
            RequestedResourceDescriptor itemResourceDescriptor = this.getItemResourceDescriptor(requestUri, client);
            if (itemResourceDescriptor.getResourceType() == Resource.ResourceType.MEDIA_ITEM && (item = this.getMediaItemResource(itemResourceDescriptor)) != null) {
                Resource coverImageResource = ResourceValuesBuilder.generateThumbnailResource(item, null);
                if (coverImageResource != null) {
                    try {
                        String coverImageUrl = coverImageResource.getGeneratedURL(client.getHostInfo());
                        return super.getRequestedResourceDescription(coverImageUrl, client);
                    }
                    catch (InvalidResourceException e) {
                        this.log.warn("Cannot validate cover image resource");
                    }
                } else {
                    throw new FileNotFoundException(String.format("Cover art doesn't exist for item %s", item.getFileName()));
                }
            }
            throw new InvalidResourceRequestException(String.format("Cannot retrieve resource specified by: %s", requestUri));
        }
        return super.getRequestedResourceDescription(requestUri, client);
    }

    protected RequestedResourceDescriptor getItemResourceDescriptor(String uri, Client client) throws InvalidResourceRequestException, FileNotFoundException {
        String cleanUri = uri.substring(0, uri.indexOf(ALBUM_ART_TRUE));
        return super.getRequestedResourceDescription(cleanUri, client);
    }
}

