/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.upnp.protocol.http.transport;

public enum TransferMode {
    INTERACTIVE{

        @Override
        public String httpHeaderValue() {
            return "Interactive";
        }
    }
    ,
    BACKGROUND{

        @Override
        public String httpHeaderValue() {
            return "Background";
        }
    }
    ,
    STREAMING{

        @Override
        public String httpHeaderValue() {
            return "Streaming";
        }
    };


    public abstract String httpHeaderValue();

    public static TransferMode getValueByHttpHeaderValue(String value) throws IllegalArgumentException {
        if (value.equalsIgnoreCase("Interactive")) {
            return INTERACTIVE;
        }
        if (value.equalsIgnoreCase("Background")) {
            return BACKGROUND;
        }
        if (value.equalsIgnoreCase("Streaming")) {
            return STREAMING;
        }
        throw new IllegalArgumentException("Unsupported Transfer mode: " + value);
    }
}

