/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.upnp.protocol.http.transport;

import java.io.FileNotFoundException;
import java.util.Map;
import org.apache.http.ProtocolVersion;
import org.serviio.delivery.AudioMediaInfo;
import org.serviio.delivery.Client;
import org.serviio.delivery.HttpResponseCodeException;
import org.serviio.delivery.RangeHeaders;
import org.serviio.delivery.ResourceDeliveryProcessor;
import org.serviio.delivery.ResourceInfo;
import org.serviio.delivery.VideoMediaInfo;
import org.serviio.dlna.MediaFormatProfile;
import org.serviio.dlna.MediaFormatProfileResolver;
import org.serviio.dlna.UnsupportedDLNAMediaFileFormatException;
import org.serviio.library.entities.Image;
import org.serviio.library.entities.MediaItem;
import org.serviio.library.entities.Video;
import org.serviio.library.local.service.ImageService;
import org.serviio.library.local.service.VideoService;
import org.serviio.library.metadata.MediaFileType;
import org.serviio.library.online.OnlineItemService;
import org.serviio.library.online.metadata.OnlineItem;
import org.serviio.upnp.protocol.http.transport.DLNAProtocolHandler;
import org.serviio.upnp.protocol.http.transport.InvalidResourceRequestException;
import org.serviio.upnp.protocol.http.transport.RequestedResourceDescriptor;
import org.serviio.upnp.protocol.http.transport.TransferMode;
import org.serviio.upnp.service.contentdirectory.classes.InvalidResourceException;
import org.serviio.upnp.service.contentdirectory.classes.Resource;
import org.serviio.upnp.service.contentdirectory.command.ResourceValuesBuilder;

public class SamsungWiseLinkProtocolHandler
extends DLNAProtocolHandler {
    @Override
    public void handleResponse(Map<String, String> requestHeaders, Map<String, Object> responseHeaders, ResourceDeliveryProcessor.HttpMethod httpMethod, ProtocolVersion requestHttpVersion, ResourceInfo mediaFileResourceInfo, Integer protocolInfoIndex, TransferMode transferMode, Client client, Long streamSize, RangeHeaders range) throws HttpResponseCodeException {
        String mediaInfoHeader;
        String captionInfoHeader;
        super.handleResponse(requestHeaders, responseHeaders, httpMethod, requestHttpVersion, mediaFileResourceInfo, protocolInfoIndex, transferMode, client, streamSize, range);
        if (httpMethod == ResourceDeliveryProcessor.HttpMethod.HEAD && (captionInfoHeader = requestHeaders.get("getCaptionInfo.sec")) != null && captionInfoHeader.trim().equals("1") && mediaFileResourceInfo instanceof VideoMediaInfo && MediaItem.isLocalMedia(mediaFileResourceInfo.getResourceId())) {
            Video video = VideoService.getVideo(mediaFileResourceInfo.getResourceId());
            Resource subResource = ResourceValuesBuilder.generateSubtitlesResource(video, client.getRendererProfile());
            if (subResource != null) {
                try {
                    responseHeaders.put("CaptionInfo.sec", subResource.getGeneratedURL(client.getHostInfo()));
                }
                catch (InvalidResourceException e) {
                    this.log.warn("Cannot set caption resource, because the subtitles resource is invalid.");
                }
            }
            this.storeContentFeatures(responseHeaders, mediaFileResourceInfo, protocolInfoIndex, client);
        }
        if ((mediaInfoHeader = requestHeaders.get("getMediaInfo.sec")) != null && mediaInfoHeader.trim().equals("1") && (mediaFileResourceInfo instanceof VideoMediaInfo || mediaFileResourceInfo instanceof AudioMediaInfo)) {
            Integer durationInSeconds = mediaFileResourceInfo.getDuration();
            if (durationInSeconds == null && mediaFileResourceInfo.isLive()) {
                durationInSeconds = 18000;
            }
            if (durationInSeconds != null) {
                responseHeaders.put("MediaInfo.sec", String.format("SEC_Duration=%s;", durationInSeconds * 1000));
            }
        }
    }

    @Override
    public RequestedResourceDescriptor getRequestedResourceDescription(String requestUri, Client client) throws InvalidResourceRequestException, FileNotFoundException {
        Image image;
        RequestedResourceDescriptor originalDescriptor = super.getRequestedResourceDescription(requestUri, client);
        if (originalDescriptor.getResourceType() == Resource.ResourceType.MEDIA_ITEM && originalDescriptor.getTargetProfileName() != null && originalDescriptor.getTargetProfileName().equals(MediaFormatProfile.JPEG_SM.toString()) && (image = this.getImageResource(originalDescriptor)) != null) {
            try {
                Resource coverImageResource;
                MediaFormatProfile normalImageProfile = MediaFormatProfileResolver.resolve(image).get(0);
                if (normalImageProfile != MediaFormatProfile.JPEG_SM && (coverImageResource = ResourceValuesBuilder.generateThumbnailResource(image, null)) != null) {
                    this.log.debug("Routing the image request to cover image request");
                    try {
                        String coverImageUrl = coverImageResource.getGeneratedURL(client.getHostInfo());
                        return super.getRequestedResourceDescription(coverImageUrl, client);
                    }
                    catch (InvalidResourceException e) {
                        this.log.warn("Cannot set cover image resource, because the image resource is invalid.");
                    }
                }
            }
            catch (UnsupportedDLNAMediaFileFormatException e) {
                // empty catch block
            }
        }
        return originalDescriptor;
    }

    private Image getImageResource(RequestedResourceDescriptor originalDescriptor) {
        Image image = null;
        if (MediaItem.isLocalMedia(originalDescriptor.getResourceId())) {
            image = ImageService.getImage(originalDescriptor.getResourceId());
        } else {
            OnlineItem onlineItem = OnlineItemService.findOnlineItemById(originalDescriptor.getResourceId());
            if (onlineItem != null && onlineItem.getType() == MediaFileType.IMAGE) {
                image = (Image)onlineItem.toMediaItem();
            }
        }
        return image;
    }
}

