/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.upnp.protocol.http.transport;

import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.serviio.delivery.Client;
import org.serviio.delivery.HttpResponseCodeException;
import org.serviio.delivery.MediaFormatProfileResource;
import org.serviio.delivery.RangeHeaders;
import org.serviio.delivery.ResourceDeliveryProcessor;
import org.serviio.delivery.ResourceInfo;
import org.serviio.library.entities.MediaItem;
import org.serviio.library.local.service.MediaService;
import org.serviio.library.online.OnlineItemService;
import org.serviio.library.online.metadata.OnlineItem;
import org.serviio.upnp.protocol.http.transport.AbstractProtocolHandler;
import org.serviio.upnp.protocol.http.transport.RequestedResourceDescriptor;
import org.serviio.upnp.protocol.http.transport.TransferMode;
import org.serviio.upnp.protocol.ssdp.SSDPConstants;
import org.serviio.upnp.service.contentdirectory.ProtocolAdditionalInfo;
import org.serviio.util.DateUtils;

public class DLNAProtocolHandler
extends AbstractProtocolHandler {
    public static boolean isChunked(TransferMode transferMode, ProtocolVersion httpVersion, boolean transcoded) {
        return httpVersion == HttpVersion.HTTP_1_1 && transcoded && transferMode == TransferMode.STREAMING;
    }

    @Override
    public void handleResponse(Map<String, String> requestHeaders, Map<String, Object> responseHeaders, ResourceDeliveryProcessor.HttpMethod httpMethod, ProtocolVersion requestHttpVersion, ResourceInfo resourceInfo, Integer protocolInfoIndex, TransferMode transferMode, Client client, Long streamSize, RangeHeaders range) throws HttpResponseCodeException {
        String contentFeaturesHeader = requestHeaders.get("getcontentFeatures.dlna.org");
        this.setContentLengthResponseHeader(responseHeaders, this.getResponseContentLength(streamSize, DLNAProtocolHandler.isChunked(transferMode, requestHttpVersion, resourceInfo.isTranscoded())));
        responseHeaders.put("Date", DateUtils.formatRFC1123(new Date()));
        responseHeaders.put("Server", SSDPConstants.SERVER);
        responseHeaders.put("Cache-control", "no-cache");
        if (range != null) {
            if (range.hasHeaders(RangeHeaders.RangeUnit.SECONDS)) {
                responseHeaders.put("TimeSeekRange.dlna.org", String.format("npt=%s-%s/%s", range.getStartAsString(RangeHeaders.RangeUnit.SECONDS), range.getEndAsString(RangeHeaders.RangeUnit.SECONDS), range.getTotal(RangeHeaders.RangeUnit.SECONDS)));
            } else if (range.hasHeaders(RangeHeaders.RangeUnit.BYTES)) {
                long total = range.getTotal(RangeHeaders.RangeUnit.BYTES);
                responseHeaders.put("Content-Range", String.format("bytes %s-%s/%s", range.getStartAsLong(RangeHeaders.RangeUnit.BYTES), range.getEndAsLong(RangeHeaders.RangeUnit.BYTES), total == -1L ? "50000000000" : Long.valueOf(total)));
            }
        }
        if (contentFeaturesHeader != null) {
            if (contentFeaturesHeader.trim().equals("1")) {
                this.storeContentFeatures(responseHeaders, resourceInfo, protocolInfoIndex, client);
            } else {
                throw new HttpResponseCodeException(400);
            }
        }
        responseHeaders.put("transferMode.dlna.org", transferMode.httpHeaderValue());
        responseHeaders.put("realTimeInfo.dlna.org", "DLNA.ORG_TLAG=*");
    }

    @Override
    public boolean supportsRangeHeader(RangeHeaders.RangeUnit type, boolean http11, boolean transcoded, RangeHeaders rangeHeaders) {
        if (type == RangeHeaders.RangeUnit.BYTES) {
            if (http11 || !http11 && !transcoded) {
                return true;
            }
            Long startByte = rangeHeaders.getStartAsLong(RangeHeaders.RangeUnit.BYTES);
            Long endByte = rangeHeaders.getEndAsLong(RangeHeaders.RangeUnit.BYTES);
            return new Long(0L).equals(startByte) && endByte == null;
        }
        return transcoded;
    }

    @Override
    protected RangeHeaders unsupportedRangeHeader(RangeHeaders.RangeUnit type, RangeHeaders range, boolean http11, boolean transcoded, Long streamSize) throws HttpResponseCodeException {
        if (type == RangeHeaders.RangeUnit.BYTES) {
            if (!range.hasHeaders(RangeHeaders.RangeUnit.SECONDS) || !this.supportsRangeHeader(RangeHeaders.RangeUnit.SECONDS, http11, transcoded, range)) {
                this.log.debug("Unsupported range request, sending back 416");
                throw new HttpResponseCodeException(416);
            }
            return null;
        }
        return null;
    }

    protected void storeContentFeatures(Map<String, Object> responseHeaders, ResourceInfo resourceInfo, Integer protocolInfoIndex, Client client) {
        if (resourceInfo instanceof MediaFormatProfileResource) {
            MediaFormatProfileResource ri = (MediaFormatProfileResource)resourceInfo;
            List<? extends ProtocolAdditionalInfo> pis = client.getRendererProfile().getResourceProtocolInfo(ri.getFormatProfile()).getAdditionalInfos();
            ProtocolAdditionalInfo pi = pis.get(protocolInfoIndex != null ? protocolInfoIndex : 0);
            responseHeaders.put("contentFeatures.dlna.org", pi.buildMediaProtocolInfo(resourceInfo.isTranscoded(), resourceInfo.isLive(), ((MediaFormatProfileResource)resourceInfo).getFormatProfile().getFileType(), resourceInfo.getDuration() != null && resourceInfo.getDuration() > 0));
        }
    }

    protected MediaItem getMediaItemResource(RequestedResourceDescriptor originalDescriptor) {
        MediaItem mediaItem = null;
        if (MediaItem.isLocalMedia(originalDescriptor.getResourceId())) {
            mediaItem = MediaService.readMediaItemById(originalDescriptor.getResourceId());
        } else {
            OnlineItem onlineItem = OnlineItemService.findOnlineItemById(originalDescriptor.getResourceId());
            if (onlineItem != null) {
                mediaItem = onlineItem.toMediaItem();
            }
        }
        return mediaItem;
    }

    private void setContentLengthResponseHeader(Map<String, Object> responseHeaders, Long fileSize) {
        if (fileSize != null) {
            responseHeaders.put("Content-Length", fileSize.toString());
        }
    }

    private Long getResponseContentLength(Long filesize, boolean chunked) {
        if (!chunked && filesize != null && filesize >= 0L) {
            return filesize;
        }
        return null;
    }
}

