/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.upnp.protocol.http.transport;

import java.io.FileNotFoundException;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.serviio.delivery.Client;
import org.serviio.delivery.HttpResponseCodeException;
import org.serviio.delivery.RangeHeaders;
import org.serviio.delivery.ResourceInfo;
import org.serviio.upnp.protocol.http.transport.InvalidResourceRequestException;
import org.serviio.upnp.protocol.http.transport.RequestedResourceDescriptor;
import org.serviio.upnp.protocol.http.transport.ResourceTransportProtocolHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractProtocolHandler
implements ResourceTransportProtocolHandler {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public RequestedResourceDescriptor getRequestedResourceDescription(String requestUri, Client client) throws InvalidResourceRequestException, FileNotFoundException {
        return new RequestedResourceDescriptor(requestUri);
    }

    @Override
    public RangeHeaders handleByteRange(RangeHeaders rangeHeaders, ProtocolVersion requestHttpVersion, ResourceInfo resourceInfo, Long streamSize) throws HttpResponseCodeException {
        boolean http11;
        boolean bl = http11 = requestHttpVersion == HttpVersion.HTTP_1_1;
        if (this.supportsRangeHeader(RangeHeaders.RangeUnit.BYTES, http11, resourceInfo.isTranscoded(), rangeHeaders)) {
            long endByte;
            long startByte = rangeHeaders.getStartAsLong(RangeHeaders.RangeUnit.BYTES);
            long l = endByte = rangeHeaders.getEndAsLong(RangeHeaders.RangeUnit.BYTES) != null ? rangeHeaders.getEndAsLong(RangeHeaders.RangeUnit.BYTES) : streamSize - 1L;
            if (endByte >= startByte && startByte < streamSize) {
                return RangeHeaders.create(RangeHeaders.RangeUnit.BYTES, startByte, endByte, (long)streamSize);
            }
            this.log.debug("Unsupported range request, sending back 416");
            throw new HttpResponseCodeException(416);
        }
        return this.unsupportedRangeHeader(RangeHeaders.RangeUnit.BYTES, rangeHeaders, http11, resourceInfo.isTranscoded(), streamSize);
    }

    @Override
    public RangeHeaders handleTimeRange(RangeHeaders rangeHeaders, ProtocolVersion requestHttpVersion, ResourceInfo resourceInfo) throws HttpResponseCodeException {
        boolean http11 = requestHttpVersion == HttpVersion.HTTP_1_1;
        Integer duration = resourceInfo.getDuration();
        if (this.supportsRangeHeader(RangeHeaders.RangeUnit.SECONDS, http11, resourceInfo.isTranscoded(), rangeHeaders)) {
            Double endSecond;
            Double startSecond = rangeHeaders.getStart(RangeHeaders.RangeUnit.SECONDS);
            if (startSecond > (double)duration.intValue()) {
                this.log.debug("Unsupported time range request, sending back 416");
                throw new HttpResponseCodeException(416);
            }
            Double d = endSecond = rangeHeaders.getEnd(RangeHeaders.RangeUnit.SECONDS) != null ? rangeHeaders.getEnd(RangeHeaders.RangeUnit.SECONDS) : new Double(duration.intValue());
            if (endSecond > (double)duration.intValue()) {
                endSecond = new Double(duration.intValue());
            }
            RangeHeaders range = RangeHeaders.create(RangeHeaders.RangeUnit.SECONDS, startSecond, endSecond, (long)Long.valueOf(duration.toString()));
            if (resourceInfo.getFileSize() != null) {
                Double averageBitrate = (double)resourceInfo.getFileSize().longValue() / (double)resourceInfo.getDuration().intValue();
                Long startByte = new Double(averageBitrate * startSecond).longValue();
                Long endByte = endSecond.equals(new Long(duration.intValue())) ? resourceInfo.getFileSize().longValue() : new Double(averageBitrate * endSecond).longValue();
                range.add(RangeHeaders.RangeUnit.BYTES, startByte, endByte, resourceInfo.getFileSize());
            }
            return range;
        }
        return this.unsupportedRangeHeader(RangeHeaders.RangeUnit.SECONDS, rangeHeaders, http11, resourceInfo.isTranscoded(), null);
    }

    protected abstract boolean supportsRangeHeader(RangeHeaders.RangeUnit var1, boolean var2, boolean var3, RangeHeaders var4);

    protected abstract RangeHeaders unsupportedRangeHeader(RangeHeaders.RangeUnit var1, RangeHeaders var2, boolean var3, boolean var4, Long var5) throws HttpResponseCodeException;
}

