/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.upnp.protocol.http;

import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpRequestFactory;
import org.apache.http.HttpResponse;
import org.apache.http.impl.DefaultHttpServerConnection;
import org.serviio.upnp.protocol.http.UniversalHttpRequestFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UniversalHttpServerConnection
extends DefaultHttpServerConnection {
    private static final Logger log = LoggerFactory.getLogger(UniversalHttpServerConnection.class);
    private String connectionId;
    private HttpEntity streamedEntity;

    public UniversalHttpServerConnection(String connectionId) {
        this.connectionId = connectionId;
        log.trace(String.format("Initializing connection %s", connectionId));
    }

    protected HttpRequestFactory createHttpRequestFactory() {
        return new UniversalHttpRequestFactory();
    }

    public String getSocketAddress() {
        return this.getSocket().getRemoteSocketAddress().toString();
    }

    public void sendResponseEntity(HttpResponse response) throws HttpException, IOException {
        if (response.getEntity() != null && response.getEntity() != null) {
            this.streamedEntity = response.getEntity();
        }
        super.sendResponseEntity(response);
    }

    public void closeEntityStream() {
        try {
            if (this.streamedEntity != null && this.streamedEntity.getContent() != null) {
                log.trace(String.format("Closing input stream for connection %s", this.connectionId));
                this.streamedEntity.getContent().close();
                this.streamedEntity = null;
            }
        }
        catch (IOException e) {
            log.warn(String.format("Cannot close input stream for connection %s: %s", this.connectionId, e.getMessage()));
        }
    }
}

