/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.upnp.protocol.http;

import java.io.IOException;
import java.net.Socket;
import java.net.URL;
import org.apache.http.HttpClientConnection;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.impl.DefaultHttpClientConnection;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.BasicHttpProcessor;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpRequestExecutor;
import org.apache.http.protocol.RequestContent;
import org.apache.http.protocol.RequestTargetHost;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestExecutor {
    private static HttpParams params = new BasicHttpParams();
    private static final Logger log = LoggerFactory.getLogger(RequestExecutor.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpResponse send(HttpRequest request, URL deliveryURL) throws IOException, HttpException {
        BasicHttpProcessor httpproc = new BasicHttpProcessor();
        httpproc.addInterceptor((HttpRequestInterceptor)new RequestContent());
        httpproc.addInterceptor((HttpRequestInterceptor)new RequestTargetHost());
        HttpRequestExecutor httpexecutor = new HttpRequestExecutor();
        HttpHost host = new HttpHost(deliveryURL.getHost(), deliveryURL.getPort() != -1 ? deliveryURL.getPort() : 80);
        DefaultHttpClientConnection conn = new DefaultHttpClientConnection();
        BasicHttpContext context = new BasicHttpContext(null);
        context.setAttribute("http.connection", (Object)conn);
        context.setAttribute("http.target_host", (Object)host);
        try {
            log.debug(String.format("Sending HTTP request to %s:%s", host.getHostName(), host.getPort()));
            Socket socket = new Socket(host.getHostName(), host.getPort());
            conn.bind(socket, params);
            request.setParams(params);
            httpexecutor.preProcess(request, (HttpProcessor)httpproc, (HttpContext)context);
            HttpResponse response = httpexecutor.execute(request, (HttpClientConnection)conn, (HttpContext)context);
            response.setParams(params);
            httpexecutor.postProcess(response, (HttpProcessor)httpproc, (HttpContext)context);
            socket.close();
            HttpResponse httpResponse = response;
            return httpResponse;
        }
        finally {
            conn.close();
        }
    }

    static {
        params.setIntParameter("http.socket.timeout", 30000);
        params.setParameter("http.protocol.version", (Object)HttpVersion.HTTP_1_1);
        params.setParameter("http.protocol.content-charset", (Object)"UTF-8");
    }
}

