/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.upnp.protocol;

import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateApplicator {
    private static final Logger log = LoggerFactory.getLogger(TemplateApplicator.class);
    private static Configuration cfg = new Configuration();

    public static String applyTemplate(String templateName, Map<String, Object> parameters) {
        try {
            Template temp = cfg.getTemplate(templateName);
            StringWriter out = new StringWriter();
            temp.process(parameters, (Writer)out);
            ((Writer)out).flush();
            return ((Object)out).toString();
        }
        catch (IOException e) {
            log.error(String.format("Cannot find template %s", templateName), (Throwable)e);
            return null;
        }
        catch (TemplateException e) {
            log.error(String.format("Error processing template %s: %s", templateName, e.getMessage()), (Throwable)e);
            return null;
        }
    }

    static {
        try {
            cfg.setClassForTemplateLoading(TemplateApplicator.class, "/");
            cfg.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
            cfg.setOutputEncoding("UTF-8");
            cfg.setURLEscapingCharset(null);
        }
        catch (Exception e) {
            log.error("Cannot initialize Freemarker engine", (Throwable)e);
        }
    }
}

