/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.upnp.eventing;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import org.serviio.upnp.Device;
import org.serviio.upnp.eventing.Subscription;
import org.serviio.upnp.service.Service;
import org.serviio.util.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventSubscriptionExpirationChecker
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(EventSubscriptionExpirationChecker.class);
    private static final int CHECK_FREQUENCY = 2000;
    private boolean workerRunning = false;

    @Override
    public void run() {
        log.info("Starting EventSubscriptionExpirationChecker");
        Device device = Device.getInstance();
        this.workerRunning = true;
        GregorianCalendar currentDate = new GregorianCalendar();
        while (this.workerRunning) {
            currentDate.setTime(new Date());
            for (Service service : device.getServices()) {
                Iterator<Subscription> subscrIt = service.getEventSubscriptions().iterator();
                while (subscrIt.hasNext()) {
                    Subscription subscription = subscrIt.next();
                    if (subscription.getDuration().equals("infinite")) continue;
                    try {
                        Integer duration = Integer.valueOf(subscription.getDuration());
                        GregorianCalendar expirationDate = new GregorianCalendar();
                        expirationDate.setTime(subscription.getCreated());
                        ((Calendar)expirationDate).add(13, duration);
                        if (expirationDate.compareTo(currentDate) >= 0) continue;
                        subscrIt.remove();
                        log.debug(String.format("Removed expired subscription %s from service %s", subscription.getUuid(), service.getServiceId()));
                    }
                    catch (NumberFormatException e) {
                        log.warn(String.format("Provided subscription duration is not a number (%s), cancelling the subscription", subscription.getDuration()));
                        subscrIt.remove();
                    }
                }
            }
            ThreadUtils.currentThreadSleep(2000L);
        }
        log.info("Leaving EventSubscriptionExpirationChecker, removing all event subscriptions");
        this.removeAllSubscriptions();
    }

    public void stopWorker() {
        this.workerRunning = false;
    }

    private void removeAllSubscriptions() {
        for (Service service : Device.getInstance().getServices()) {
            Iterator<Subscription> subscrIt = service.getEventSubscriptions().iterator();
            while (subscrIt.hasNext()) {
                Subscription subscription = subscrIt.next();
                subscrIt.remove();
                log.debug(String.format("Removed subscription %s from service %s", subscription.getUuid(), service.getServiceId()));
            }
        }
    }
}

