/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.upnp.eventing;

import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.serviio.upnp.Device;
import org.serviio.upnp.eventing.Subscription;
import org.serviio.upnp.protocol.TemplateApplicator;
import org.serviio.upnp.protocol.http.RequestExecutor;
import org.serviio.upnp.service.Service;
import org.serviio.upnp.service.StateVariable;
import org.serviio.util.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventDispatcher
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(EventDispatcher.class);
    private static final int RESPONSE_TIMEOUT = 500;
    private static Map<Service, Queue<EventContainer>> eventQueues = new HashMap<Service, Queue<EventContainer>>();
    private boolean workerRunning = false;

    public static void addEvent(Service service, StateVariable variable, Subscription subscription) {
        EventContainer event = new EventContainer(variable, subscription);
        if (EventDispatcher.isVariableAvailableForSending(variable)) {
            eventQueues.get(service).offer(event);
            variable.setLastEventSent(new Date());
        }
    }

    public static void addInitialEvents(Service service, Set<StateVariable> variables, Subscription subscription) {
        HashSet<EventContainer> events = new HashSet<EventContainer>(variables.size());
        for (StateVariable variable : variables) {
            events.add(new EventContainer(variable, subscription));
            variable.setLastEventSent(new Date());
        }
        eventQueues.get(service).addAll(events);
    }

    @Override
    public void run() {
        log.info("Starting EventDispatcher");
        this.workerRunning = true;
        while (this.workerRunning) {
            for (Service service : eventQueues.keySet()) {
                Queue<EventContainer> eventsQueue = eventQueues.get(service);
                HashSet<EventContainer> events = new HashSet<EventContainer>();
                while (!eventsQueue.isEmpty()) {
                    EventContainer event = eventsQueue.poll();
                    events.add(event);
                }
                if (events.isEmpty()) continue;
                for (Subscription subscription : service.getEventSubscriptions()) {
                    try {
                        EventDispatcher.sendEvents(subscription, EventDispatcher.filterEventsForSubscriber(events, subscription));
                    }
                    catch (Exception e) {
                        log.warn(String.format("Couldn't send event message for subscription %s, will keep trying until subscription expires", subscription.getUuid()));
                    }
                }
            }
            ThreadUtils.currentThreadSleep(500L);
        }
        log.info("Leaving EventDispatcher");
    }

    public void stopWorker() {
        this.workerRunning = false;
    }

    protected static void sendEvents(Subscription subscription, Set<EventContainer> events) throws HttpException, IOException {
        log.debug(String.format("Sending event notification #%s for subscription %s to endpoint %s", subscription.getKey(), subscription.getUuid(), subscription.getDeliveryURL()));
        BasicHttpEntityEnclosingRequest request = new BasicHttpEntityEnclosingRequest("NOTIFY", subscription.getDeliveryURL().getPath(), (ProtocolVersion)HttpVersion.HTTP_1_1);
        request.addHeader("NT", "upnp:event");
        request.addHeader("NTS", "upnp:propchange");
        request.addHeader("SID", "uuid:" + subscription.getUuid());
        request.addHeader("SEQ", Long.toString(subscription.getKey()));
        HashMap<String, Object> dataModel = new HashMap<String, Object>();
        dataModel.put("stateVariables", EventDispatcher.extractVariablesFromEventContainer(events));
        String message = TemplateApplicator.applyTemplate("org/serviio/upnp/protocol/templates/eventNotification.ftl", dataModel);
        StringEntity body = new StringEntity(message, "UTF-8");
        body.setContentType("text/xml");
        body.setContentEncoding("UTF-8");
        request.setEntity((HttpEntity)body);
        HttpResponse response = RequestExecutor.send((HttpRequest)request, subscription.getDeliveryURL());
        if (response.getStatusLine().getStatusCode() == 200) {
            log.debug("Event notification sent and received successfully");
        } else {
            log.warn(String.format("Error %s received from event subscriber", response.getStatusLine().getStatusCode()));
        }
        subscription.increaseKey();
    }

    private static Set<EventContainer> filterEventsForSubscriber(Set<EventContainer> events, Subscription subscription) {
        HashSet<EventContainer> filteredEvents = new HashSet<EventContainer>();
        for (EventContainer event : events) {
            if (event.getSubscription() != null && !event.getSubscription().equals(subscription)) continue;
            filteredEvents.add(event);
        }
        return filteredEvents;
    }

    private static Set<StateVariable> extractVariablesFromEventContainer(Set<EventContainer> events) {
        HashSet<StateVariable> variables = new HashSet<StateVariable>();
        for (EventContainer event : events) {
            variables.add(event.getVariable());
        }
        return variables;
    }

    private static boolean isVariableAvailableForSending(StateVariable variable) {
        if (variable.getModerationInterval() == 0 || variable.getLastEventSent() == null) {
            return true;
        }
        GregorianCalendar lastSent = new GregorianCalendar();
        lastSent.setTime(variable.getLastEventSent());
        ((Calendar)lastSent).add(14, variable.getModerationInterval());
        GregorianCalendar currentDate = new GregorianCalendar();
        currentDate.setTime(new Date());
        return currentDate.compareTo(lastSent) >= 0;
    }

    static {
        for (Service service : Device.getInstance().getServices()) {
            eventQueues.put(service, new ConcurrentLinkedQueue());
        }
    }

    private static class EventContainer {
        private StateVariable variable;
        private Subscription subscription;

        public EventContainer(StateVariable variable, Subscription subscription) {
            this.variable = variable;
            this.subscription = subscription;
        }

        public StateVariable getVariable() {
            return this.variable;
        }

        public Subscription getSubscription() {
            return this.subscription;
        }
    }
}

