/*
 * Decompiled with CFR 0.152.
 */
package org.serviio.upnp.discovery;

import org.serviio.upnp.discovery.WakeUpListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WakeUpMonitor
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(WakeUpMonitor.class);
    private final int minSleepTime;
    private final WakeUpListener listener;
    private long lastTimestamp = -1L;

    public WakeUpMonitor(int minSleepTime, WakeUpListener listener) {
        this.minSleepTime = minSleepTime;
        this.listener = listener;
    }

    public void reset() {
        this.lastTimestamp = -1L;
    }

    @Override
    public void run() {
        long currentTimestamp = System.currentTimeMillis();
        if (this.lastTimestamp > -1L && currentTimestamp - (long)this.minSleepTime > this.lastTimestamp) {
            log.debug("System coming out from sleep detected, notifying listeners");
            this.listener.onWakeUp();
        }
        this.lastTimestamp = currentTimestamp;
    }
}

